% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method_brplus.R
\name{predict.BRPmodel}
\alias{predict.BRPmodel}
\title{Predict Method for BR+ (brplus)}
\usage{
\method{predict}{BRPmodel}(object, newdata, strategy = c("Dyn", "Stat", "Ord",
  "NU"), order = list(), probability = getOption("utiml.use.probs", TRUE),
  ..., cores = getOption("utiml.cores", 1), seed = getOption("utiml.seed",
  NA))
}
\arguments{
\item{object}{Object of class '\code{BRPmodel}'.}

\item{newdata}{An object containing the new input data. This must be a
matrix, data.frame or a mldr object.}

\item{strategy}{The strategy prefix to determine how to estimate the values
 of the augmented features of unlabeled examples.

 The possible values are: \code{'Dyn'}, \code{'Stat'}, \code{'Ord'} or
 \code{'NU'}. See the description for more details. (Default: \code{'Dyn'}).}

\item{order}{The label sequence used to update the initial labels results
based on the final results. This argument is used only when the
\code{strategy = 'Ord'} (Default: \code{list()})}

\item{probability}{Logical indicating whether class probabilities should be
returned. (Default: \code{getOption("utiml.use.probs", TRUE)})}

\item{...}{Others arguments passed to the base algorithm prediction for all
subproblems.}

\item{cores}{The number of cores to parallelize the training. Values higher
than 1 require the \pkg{parallel} package. (Default:
\code{options("utiml.cores", 1)})}

\item{seed}{An optional integer used to set the seed. This is useful when
the method is run in parallel. (Default: \code{options("utiml.seed", NA)})}
}
\value{
An object of type mlresult, based on the parameter probability.
}
\description{
This function predicts values based upon a model trained by \code{brplus}.
}
\details{
The strategies of estimate the values of the new features are separated in
two groups:
\describe{
 \item{No Update (\code{NU})}{This use the initial prediction of BR to all
  labels. This name is because no modification is made to the initial
  estimates of the augmented features during the prediction phase}
 \item{With Update}{This strategy update the initial prediction in that the
  final predict occurs. There are three possibilities to define the order of
  label sequences:
   \describe{
     \item{Specific order (\code{Ord})}{The order is define by the user,
      require a new argument  called \code{order}.}
     \item{Static order (\code{Stat})}{Use the frequency of single labels in
      the training set to define the sequence, where the least frequent
      labels are predicted first}
     \item{Dinamic order (\code{Dyn})}{Takes into account the confidence of
      the initial prediction for each independent single label, to define a
      sequence, where the labels predicted with less confidence are updated
      first.}
   }
 }
}
}
\examples{
# Predict SVM scores
model <- brplus(toyml, "RANDOM")
pred <- predict(model, toyml)

\dontrun{
# Predict SVM bipartitions and change the method to use No Update strategy
pred <- predict(model, toyml, strategy = 'NU', probability = FALSE)

# Predict using a random sequence to update the labels
labels <- sample(rownames(dataset$train$labels))
pred <- predict(model, toyml, strategy = 'Ord', order = labels)

# Passing a specif parameter for SVM predict method
pred <- predict(model, toyml, na.action = na.fail)
}
}
\references{
Cherman, E. A., Metz, J., & Monard, M. C. (2012). Incorporating label
   dependency into the binary relevance framework for multi-label
   classification. Expert Systems with Applications, 39(2), 1647-1655.
}
\seealso{
\code{\link[=brplus]{BR+}}
}
