% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zipfplot.R
\name{zipfplot}
\alias{zipfplot}
\title{Generate Zipf plot}
\usage{
zipfplot(
  x,
  relative.freq = TRUE,
  smooth.line = TRUE,
  smooth.conf = TRUE,
  conf.level = 0.99,
  separate.plots = FALSE,
  data.name = FALSE,
  point.size = 3,
  point.alpha = 0.4
)
}
\arguments{
\item{x}{Data vector, matrix or data-frame}

\item{relative.freq}{Logical; if \code{TRUE} the plot shows the relative frequency on vertical axis}

\item{smooth.line}{Logical; if \code{TRUE} the plot shows a smoothed line through the data using LOESS method}

\item{smooth.conf}{Logical; if \code{TRUE} the plot shows confidence bands on the smoothed line (only shown if smoothed line is shown)}

\item{conf.level}{The confidence level for the confidence bands on the smoothed line}

\item{separate.plots}{Logical; if \code{TRUE} the plot shows}

\item{data.name}{Logical; if \code{TRUE} the subtitle will state the name of the input data}

\item{point.size}{Size of the points in the plot}

\item{point.alpha}{Alpha-transparency of the points in the plot}
}
\value{
Zipf plot for the input data
}
\description{
\code{zipfplot} generates the Zipf plot for the input data
}
\details{
The Zipf plot for a dataset shows the ranks of outcomes versus their frequency on a log-log scale.
It is used to determine how closely a dataset follows "Zipf's law".  The present function takes in
a vector of values and produces the Zipf plot.  The data input can be either a vector, a matrix or
a data frame.  If the input data is a vector then the output will be a Zipf plot for that data vector.
If the input data is a matrix or data frame then each column will be treated as a separate variable
and the output will be a single Zipf plot showing each of the variables.  The user can control
whether the variables are shown on a single plot or separate plots.
}
\examples{
try(zipfplot(sample(LETTERS, 300, replace = TRUE)))
}
