% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc.R
\name{calc_duration}
\alias{calc_duration}
\title{Calculate durations of time}
\usage{
calc_duration(start = NA, end = NA, units = NA)
}
\arguments{
\item{start}{Required. Date or POSIXt object. The start date/timestamp.}

\item{end}{Required. Date or POSIXt object. The end date/timestamp.}

\item{units}{Optional. Character. Units of the returned duration
(i.e. 'seconds', 'days', 'years').}
}
\value{
If 'units' specified, returns numeric. If 'units' unspecified,
returns an object of class '\code{\link[lubridate:Duration-class]{Duration}}'.
}
\description{
Calculates the duration of time between two provided date objects.
Supports vectorized data (i.e. \code{\link[dplyr:mutate]{dplyr::mutate()}}).
}
\note{
Supports multiple calculations against a single time point (i.e.
multiple start dates with a single end date). Note that start and end
must otherwise be of the same length.
}
\examples{
# Timestamps
calc_duration(
   start = as.POSIXct('01/01/1999 10:00', format = '\%m/\%d/\%Y \%H:\%M'),
   end = as.POSIXct('01/01/2001 00:00', format = '\%m/\%d/\%Y \%H:\%M'),
   units = 'days'
)

# Dates
calc_duration(
   start = as.Date('01/01/1999', format = '\%m/\%d/\%Y'),
   end = as.Date('01/01/2001', format = '\%m/\%d/\%Y'),
   units = 'years'
)
}
