% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform.R
\name{usmap_transform}
\alias{usmap_transform}
\alias{usmap_transform.sf}
\alias{usmap_transform.data.frame}
\title{Convert spatial data to usmap projection}
\usage{
usmap_transform(data, ...)

\method{usmap_transform}{sf}(data, ...)

\method{usmap_transform}{data.frame}(data, ..., input_names = c("lon", "lat"), output_names = NULL)
}
\arguments{
\item{data}{A data frame containing coordinates in a two column format
where the first column represents longitude and the second data frame
represents latitude. The names of the data frame column do not matter,
just that the order of the columns is kept intact.}

\item{...}{Additional parameters passed onto \link[sf:st_as_sf]{sf::st_as_sf}.
By default, \code{crs = sf::st_crs(4326)} is used, implying longitude and latitude
coordinates.}

\item{input_names}{A character vector of length two which specifies the
longitude and latitude columns of the input data (the ones that should be
transformed), respectively. Only required if the input data is
a \code{data.frame} object. Defaults to \code{c("lon", "lat")}.}

\item{output_names}{Defunct, this parameter is no longer used. The output
of this function will have a column named \code{"geometry"} with the transformed
coordinates. This parameter may be removed in a future version.}
}
\value{
An \code{sf} object containing the transformed coordinates from the
input data frame with the US National Atlas Equal Area projection applied.
The transformed columns will be appended to the data frame so that all
original columns should remain intact.
}
\description{
Converting a spatial object of map coordinates will
allow those points to line up with the regular usmap plot by applying
the same US National Atlas Equal Area projection (including Alaska and
Hawaii of course) to those points as well.

The input \code{data} is assumed to contain longitude and latitude coordinates
by default. If this is not the case, provide an \link[sf:st_crs]{sf::st_crs} object
to the \code{crs} parameter with the appropriate coordinate reference system.
}
\examples{
data <- data.frame(
  lon = c(-74.01, -95.36, -118.24, -87.65, -134.42, -157.86),
  lat = c(40.71, 29.76, 34.05, 41.85, 58.30, 21.31),
  pop = c(8398748, 2325502, 3990456, 2705994, 32113, 347397)
)

# Transform data
transformed_data <- usmap_transform(data)

# Plot transformed data on map
library(ggplot2)

plot_usmap() + geom_sf(
  data = transformed_data,
  aes(size = pop),
  color = "red", alpha = 0.5
)

}
