% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/github-action.R
\name{use_github_action}
\alias{use_github_action}
\alias{use_github_action_check_release}
\alias{use_github_action_check_full}
\alias{use_github_action_pr_commands}
\title{Use a specific GitHub action}
\usage{
use_github_action(
  name,
  url = NULL,
  save_as = NULL,
  ignore = TRUE,
  open = FALSE
)

use_github_action_check_release(
  save_as = "R-CMD-check.yaml",
  ignore = TRUE,
  open = FALSE
)

use_github_action_check_full(
  save_as = "R-CMD-check.yaml",
  ignore = TRUE,
  open = FALSE
)

use_github_action_pr_commands(
  save_as = "pr-commands.yaml",
  ignore = TRUE,
  open = FALSE
)
}
\arguments{
\item{name}{Name of the GitHub action, with or without \code{.yaml} extension}

\item{url}{The full URL to the GitHub Actions yaml file.
By default, the corresponding action in https://github.com/r-lib/actions
will be used.}

\item{save_as}{Name of the actions file. Defaults to \code{basename(url)}
for \code{use_github_action()}.}

\item{ignore}{Should the newly created file be added to \code{.Rbuildignore}?}

\item{open}{Open the newly created file for editing? Happens in RStudio, if
applicable, or via \code{\link[utils:file.edit]{utils::file.edit()}} otherwise.}
}
\description{
Use a specific action, either one of the example actions from
\href{https://github.com/r-lib/actions/tree/master/examples}{r-lib/actions/examples}
or a custom action given by the \code{url} parameter.
}
\section{\code{use_github_action_check_release()}}{

This action installs the latest release R version on macOS and runs \verb{R CMD check}
via the \href{https://github.com/r-lib/rcmdcheck}{rcmdcheck} package.
}

\section{\code{use_github_action_check_full()}}{

This action installs the last 5 minor R versions and runs R CMD check
via the \href{https://github.com/r-lib/rcmdcheck}{rcmdcheck} package on the
three major OSs (linux, macOS and Windows). This action is what the
tidyverse teams uses on their repositories, but is overkill for less
widely used packages, which are better off using the simpler
\code{use_github_action_check_release()}.
}

\section{\code{use_github_action_pr_commands()}}{

This workflow enables the use of 2 R specific commands in pull request
issue comments. \verb{/document} will use
\href{https://roxygen2.r-lib.org/}{roxygen2} to rebuild the documentation for
the package and commit the result to the pull request. \verb{/style} will use
\href{https://styler.r-lib.org/}{styler} to restyle your package.
}

\seealso{
\link{github_actions} for generic workflows.
}
