\name{scaleDiagnosisToPDF}
\alias{scaleDiagnosisToPDF}
\title{
scaleDiagnosisToPDF
}
\description{
\code{\link{scaleDiagnosis}} provides a number of diagnostics for a scale
(an aggregative measure consisting of several items), and
scaleDiagnosisToPDF takes the resulting object and generates a PDF
file, which is then saved to disk.
}
\usage{
scaleDiagnosisToPDF(scaleDiagnosisObject,
                    docTitle = "Scale diagnosis", docAuthor = "Author",
                    pdfLatexPath, rnwPath=getwd(),
                    filename = "scaleDiagnosis",
                    digits=2,
                    rMatrixColsLandscape = 6,
                    pboxWidthMultiplier = 1,
                    scatterPlotBaseSize = 4,
                    maxScatterPlotSize = NULL,
                    pageMargins=15,
                    pval=TRUE)
}
\arguments{
  \item{scaleDiagnosisObject}{
  An object generated by \code{\link{scaleDiagnosis}}.
}
  \item{docTitle}{
  The title of the PDF file (printed on the first page).
}
  \item{docAuthor}{
  The author to show in the PDF file (printed on the first page).
}
  \item{pdfLatexPath}{
  The path to PdfLaTex. This file is part of a LaTeX installation that
  creates a pdf out of a .tex file. See \code{\link{rnwString}}
  for more information.
}
  \item{rnwPath}{
  The path where the temporary files will be stored.
}
  \item{filename}{
  Filename of the PDF (".pdf" is appended).
}
  \item{digits}{
  Number of digits to show.
}
  \item{rMatrixColsLandscape}{
  This number determines when the page(s) in the PDF is/are rotated;
  pages with matrices that have this number of columns or more are rotated.
}
  \item{pboxWidthMultiplier}{
  Passed on to \code{\link{print.rMatrix}}.
}
  \item{scatterPlotBaseSize}{
  Basic size of scatterplots in centimeters. If this number, multiplied by
  the number of items (i.e. columns/rows in scattermatrix) is larger than
  maxScatterPlotSize, it is ignored.
}
  \item{maxScatterPlotSize}{
  Maximum size of scatterplots; automatically calculated if NULL.
}
  \item{pageMargins}{
  Margins of landscape pages in millimeters.
}
  \item{pval}{
  Whether to print p-values using the p-value formatting.
  Passed on to \code{\link{print.rMatrix}}.
}
}
\details{

This functon generates a PDF file from a \code{\link{scaleDiagnosis}} object.
\code{\link{scaleDiagnosis}} generates an object with several useful statistics
and a plot to assess how the elements (usually items) in a scale relate to each
other, such as Cronbach's Alpha, omega, the Greatest Lower Bound, a factor
analysis, and a correlation matrix.

}
\value{

Nothing is returned; the file is printed to disk.

}
\examples{

\dontrun{

### Generate a datafile to use
exampleData <- data.frame(item1=rnorm(100));
exampleData$item2 <- exampleData$item1+rnorm(100);
exampleData$item3 <- exampleData$item1+rnorm(100);
exampleData$item4 <- exampleData$item2+rnorm(100);
exampleData$item5 <- exampleData$item2+rnorm(100);

### Use all items and create object
scaleDiagnosisObject <- scaleDiagnosis(dat=exampleData);

### Generate a PDF
scaleDiagnosisToPDF(scaleDiagnosisObject);

}
}
\keyword{ utilities }