% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/others.R
\name{is_between}
\alias{is_between}
\title{Is value between two others?}
\usage{
is_between(value, low.thres, high.thres, include.high.value = FALSE)
}
\arguments{
\item{value}{numeric}

\item{low.thres}{numeric. Lower boundary of the interval.}

\item{high.thres}{numeric. Upper boundary of the interval.}

\item{include.high.value}{logical. Whether the upper bound is included in the
interval or not. Default value: FALSE.}
}
\value{
a logical specifying if the \code{value} is inside the interval
\code{[low.thres,high.thres)} (default behaviour) or inside the interval
\code{[low.thres,high.thres]} if \code{include.high.value} is TRUE.
}
\description{
This function checks if a given value is inside an interval specified by
two boundary values.
}
\examples{
is_between(3,2,4)
is_between(4,2,4)
is_between(4,2,4,include.high.value=TRUE)

}
