% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init.R
\name{initialize_startr}
\alias{initialize_startr}
\title{Initialize startr project}
\usage{
initialize_startr(
  author = "Firstname Lastname <firstlast@example.com>",
  title = "startr",
  scipen = 999,
  timezone = "America/Toronto",
  should_render_notebook = FALSE,
  should_process_data = TRUE,
  should_timestamp_output_files = FALSE,
  should_clean_processing_variables = TRUE,
  should_beep = TRUE,
  set_minimal_graphics_theme = TRUE,
  packages = c()
)
}
\arguments{
\item{author}{Name and email of the startr project author}

\item{title}{Title of the startr project}

\item{scipen}{Which level of scientific precision to use. (Default: 999)}

\item{timezone}{The timezone for analysis. (Default: 'America/Toronto')}

\item{should_render_notebook}{Whether the RMarkdown notebook should be rendered. (Default: FALSE)}

\item{should_process_data}{Whether startr's process step should be run. (Default: TRUE)}

\item{should_timestamp_output_files}{Whether write_excel's output files should be timestamped. (Default: FALSE)}

\item{should_clean_processing_variables}{Whether processing variables should be cleaned
from the environment after processing is complete. (Default: TRUE)}

\item{should_beep}{Whether startr should beep after tasks like processing or knitting RMarkdown notebooks. (Default: TRUE)}

\item{set_minimal_graphics_theme}{Whether the minimal graphics theme should be used. (Default: TRUE)}

\item{packages}{Vector of package names, from CRAN, Github or Bioconductor to be installed.
If using GitHub, package names should be in the format 'user/repo', e.g. 'globeandmail/upstartr'.}
}
\value{
No return value, called for side effects
}
\description{
Used to initialize a startr template for analysis. Will enforce some startr-required
standards for analysis (such as removing scientific notation, setting timezones, and
writing some project configs to `options`).
}
