% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/style.R
\name{chartLayout}
\alias{chartLayout}
\title{specify the chart layout}
\usage{
chartLayout(
  upsetjs,
  height.ratios = NULL,
  width.ratios = NULL,
  padding = NULL,
  bar.padding = NULL,
  dot.padding = NULL,
  numerical.scale = NULL,
  band.scale = NULL,
  set.label.alignment = NULL,
  set.max.scale = NULL,
  combination.max.scale = NULL
)
}
\arguments{
\item{upsetjs}{an object of class \code{upsetjs} or \code{upsetjs_proxy}}

\item{height.ratios}{a vector of length 2 for the ratios between the combination and set plot, e.g. c(0.6, 0.4)}

\item{width.ratios}{a vector of length 3 for the ratios between set, label, and combination plot, e.g. c(0.3,0.2,0.5)}

\item{padding}{padding around the plot}

\item{bar.padding}{padding ratio (default 0.1) for the bar charts}

\item{dot.padding}{padding factor (default 0.7) for the dots}

\item{numerical.scale}{numerical scale: linear (default) or log}

\item{band.scale}{band scale: band (default)}

\item{set.label.alignment}{set label alignment: left, center (default), right}

\item{set.max.scale}{maximum value for the set scale}

\item{combination.max.scale}{maximum value for the combination scale}
}
\value{
the object given as first argument
}
\description{
specify the chart layout
}
\examples{
upsetjs() \%>\%
  fromList(list(a = c(1, 2, 3), b = c(2, 3))) \%>\%
  chartLayout(width.ratios = c(0.4, 0.2, 0.4))
}
