% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_text_calls.R
\name{uline}
\alias{uline}
\title{Plot underlined text elements.}
\usage{
uline(
  labels,
  x = 0,
  y = 0.55,
  x_layout = NA,
  y_layout = "even",
  col = "black",
  col_bg = Seeblau,
  cex = 1.5,
  font = 1,
  new_plot = "none"
)
}
\arguments{
\item{labels}{A character vector specifying the text labels 
to be plotted.}

\item{x}{A numeric vector of x-coordinates at which the 
text labels in \code{labels} should be written. 
If the lengths of \code{x} and \code{y} differ, 
the shorter one is recycled. 
Default: \code{x = 0}.}

\item{y}{A numeric vector of y-coordinates at which the 
text labels in \code{labels} should be written. 
If the lengths of \code{x} and \code{y} differ, 
the shorter one is recycled. 
Default: \code{y = .55}.}

\item{x_layout}{An optional numeric vector or character string
to control the horizontal positions of \code{labels}. 
Numeric values are interpreted as increments to values of \code{x} 
and recycled (to enable stepwise or alternating patterns). 
3 character string options are: 
\code{"center"} (i.e., center wrt. first label or plot center),
\code{"left"} (i.e., left wrt. first label or plot center), 
\code{"right"} (i.e., right wrt. first label or plot center). 
Default: \code{x_layout = NA} (i.e., using values of \code{x}).}

\item{y_layout}{A numeric value or character string 
to control the vertical positions of \code{labels}. 
Numeric values are interpreted as increments to values of \code{y[1]} 
and recycled (to enable stepwise or alternating patterns). 
2 character string options are: 
\code{"even"} (i.e., even distribution of labels across available y-space) and 
\code{"flush"} (i.e., no space between adjacent labels, i.e., \code{y_layout = 0}). 
Default: \code{y_layout = "even"}.}

\item{col}{The color(s) of the text label(s). 
Default: \code{col_lbl = "black"}.}

\item{col_bg}{The color(s) of the line (under the text labels 
of \code{labels}). 
Default: \code{col_bg = Seeblau}.}

\item{cex}{Numeric character expansion factor(s), 
multiplied by \code{par("cex")} to yield the character size(s). 
Default: \code{cex = 1.5}.}

\item{font}{The font type(s) to be used. 
Default: \code{font = 1} (i.e., plain text).}

\item{new_plot}{Boolean: Should a new plot be generated?
Set to \code{"blank"} or \code{"slide"} to create a new plot. 
Default: \code{new_plot = "none"} (i.e., add to an existing plot).}
}
\description{
\code{uline} plots 1 or more text strings (provided as a character vector \code{labels}) 
to an (existing or new) plot and places a colored line underneath   
each label (to underline it).
}
\details{
The positions of the text elements in \code{labels} can be specified by 
providing their coordinates (as \code{x} and \code{y} arguments) or 
by providing an initial position and an \code{y_layout} (see below). 

Text formatting parameters (like \code{col}, \code{col_bg}, \code{cex}, \code{font})         
are recycled to match \code{length(labels)}. 

\code{uline} uses the base graphics system \code{graphics::}.
}
\examples{
uline(labels = "This is a test.", new_plot = "blank")  # create a new blank plot
uline(labels = "More testing here...", y = .33, col_bg = pal_pinky[[2]])  # add to plot

# 2 basic cases: 
# (a) Underline text on an existing plot:
plot(x = 0, y = 0, type = "n", xlim = c(0, 1), ylim = c(0, 1), xlab = "", ylab = "")
uline(x = 0, y = .8, labels = "Underline text (on an existing plot)")  # add to plot

# (b) Underline text on a new plot:
uline(x = .02, y = .80, labels = "Underline text (on a new plot)", 
     new_plot = "slide")  # create a new plot

# Example:
lbl_line <- c("This is neat, true, and terribly important.")
uline(labels = lbl_line, new_plot = "blank")  # create a new plot
uline(labels = "(which is why we underline it).", y = .40, cex = 1.2)  # add to plot

# Using x_layout and y_layout:
uline(labels = c("Ene,", "mene, miste,", "es rappelt", "in der Kiste."), 
     cex = 1.4, font = 2, col = Grau, col_bg = Pinky,
     x = 1.2, y = .85, x_layout = "right", y_layout = "even", new_plot = "slide")
                                      
}
\seealso{
\code{\link{slide}} and \code{\link{xbox}} to create simple plots (without text).

Other text functions: 
\code{\link{mark}()},
\code{\link{post}()},
\code{\link{url_unikn}()}
}
\concept{text functions}
