% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scene_management.R
\name{new_scene}
\alias{new_scene}
\title{Create a new scene in a Unity project.}
\usage{
new_scene(
  script,
  setup = c("EmptyScene", "DefaultGameObjects"),
  mode = c("Additive", "Single"),
  method_name = NULL,
  exec = TRUE
)
}
\arguments{
\item{script}{A \code{unifir_script} object, created by \link{make_script} or returned
by an \verb{add_prop_*} function.}

\item{setup}{One of "EmptyScene"
("No game objects are added to the new Scene.") or "DefaultGameObjects"
("Adds default game objects to the new Scene (a light and camera).")}

\item{mode}{One of "Additive"
("The newly created Scene is added to the current open Scenes.") or "Single"
("All current open Scenes are closed and the newly created Scene are
opened.")}

\item{method_name}{The internal name to use for the C# method created. Will
be randomly generated if not set.}

\item{exec}{Logical: Should the C# method be included in the set executed by
MainFunc?}
}
\description{
Create a new scene in a Unity project.
}
\examples{
# First, create a script object.
# CRAN doesn't have Unity installed, so pass
# a waiver object to skip the Unity-lookup stage:
script <- make_script("example_script",
  unity = waiver()
)

# Now add props:
script <- new_scene(script)

# Lastly, execute the script via the `action` function
}
\seealso{
Other props: 
\code{\link{add_default_player}()},
\code{\link{add_light}()},
\code{\link{add_prop}()},
\code{\link{add_texture}()},
\code{\link{create_terrain}()},
\code{\link{import_asset}()},
\code{\link{instantiate_prefab}()},
\code{\link{load_png}()},
\code{\link{load_scene}()},
\code{\link{read_raw}()},
\code{\link{save_scene}()},
\code{\link{set_active_scene}()},
\code{\link{validate_path}()}

Other utilities: 
\code{\link{add_default_player}()},
\code{\link{add_prop}()},
\code{\link{create_unity_project}()},
\code{\link{find_unity}()},
\code{\link{get_asset}()},
\code{\link{load_png}()},
\code{\link{load_scene}()},
\code{\link{read_raw}()},
\code{\link{save_scene}()},
\code{\link{set_active_scene}()},
\code{\link{validate_path}()},
\code{\link{waiver}()}
}
\concept{props}
\concept{utilities}
