% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate_path.R
\name{validate_path}
\alias{validate_path}
\alias{validate_single_path}
\title{Validate a file path exists}
\usage{
validate_path(script, method_name = NULL, exec = FALSE)

validate_single_path(script, path, method_name = NULL, exec = TRUE)
}
\arguments{
\item{script}{A \code{unifir_script} object, created by \link{make_script} or returned
by an \verb{add_prop_*} function.}

\item{method_name}{The internal name to use for the C# method created. Will
be randomly generated if not set.}

\item{exec}{Logical: Should the C# method be included in the set executed by
MainFunc?}

\item{path}{The file path to validate}
}
\description{
\link{validate_path} creates a generic C# method which takes a single argument
and checks to make sure it exists. Your C# code calling the method must
provide the path to validate.
\link{validate_single_path} hard-codes the path to check in the C# code. This
allows you to specify the path to check from R.
}
\examples{
# First, create a script object.
# CRAN doesn't have Unity installed, so pass
# a waiver object to skip the Unity-lookup stage:
script <- make_script("example_script", unity = waiver())

# Now add props:
script <- validate_path(script) # Don't specify the path in R
script <- validate_single_path( # Specify the path in R
  script,
  "file_that_exists.txt"
)
}
\seealso{
Other props: 
\code{\link{add_default_player}()},
\code{\link{add_light}()},
\code{\link{add_prop}()},
\code{\link{add_texture}()},
\code{\link{create_terrain}()},
\code{\link{import_asset}()},
\code{\link{instantiate_prefab}()},
\code{\link{load_png}()},
\code{\link{load_scene}()},
\code{\link{new_scene}()},
\code{\link{read_raw}()},
\code{\link{save_scene}()},
\code{\link{set_active_scene}()}

Other utilities: 
\code{\link{add_default_player}()},
\code{\link{add_prop}()},
\code{\link{create_unity_project}()},
\code{\link{find_unity}()},
\code{\link{get_asset}()},
\code{\link{load_png}()},
\code{\link{load_scene}()},
\code{\link{new_scene}()},
\code{\link{read_raw}()},
\code{\link{save_scene}()},
\code{\link{set_active_scene}()},
\code{\link{waiver}()}
}
\concept{props}
\concept{utilities}
