% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Concordia.R
\docType{data}
\name{conc_4}
\alias{conc_4}
\title{Neutral colors of Concordia University, Canada}
\format{
An object of class \code{character} of length 5.
}
\source{
Color definitions are based on 
\href{https://www.concordia.ca/web/design/ui-kit-style-guide-accessibility/web-palette-new.html}{Concordia's NEW web colour palette}.
}
\usage{
conc_4
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{conc_4} provides the five neutral colors 
of the \href{https://www.concordia.ca/}{Concorida University}, Canada.
}
\details{
The five neutral colors are 
\code{"light_grey_concordia"}     (defined as HEX #f0f0f0),
\code{"medium_grey_concordia"}    (defined as HEX #c8c8c8), 
\code{"dark_grey_concordia"}      (defined as HEX #6e6e6e),
\code{"very_dark_grey_concordia"} (defined as HEX #2c2c2c), and
\code{"black"}                    (defined as HEX #000000).

\code{conc_4} uses the HEX color definitions.
}
\examples{
conc_4
unikn::seecol(conc_4, main = "Concordia University") # view color palette

}
\seealso{
\code{\link{conc_1}} for primary colors of Concordia University;
\code{\link{conc_2}} for secondary colors of Concordia University;
\code{\link{conc_3}} for background colors of Concordia University;
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.

Other Canadian university color palettes: 
\code{\link{carleton}},
\code{\link{conc_1}},
\code{\link{conc_2}},
\code{\link{conc_3}},
\code{\link{guelph}},
\code{\link{laval}},
\code{\link{manitoba_1}},
\code{\link{manitoba_2}},
\code{\link{mcgill_brights}},
\code{\link{mcgill_darks}},
\code{\link{mcgill_grey}},
\code{\link{mcgill_muted}},
\code{\link{mcgill_pastels}},
\code{\link{mcgill_red}},
\code{\link{mcmaster_brighterworld}},
\code{\link{mcmaster_heritage}},
\code{\link{mun_1}},
\code{\link{mun_2}},
\code{\link{queensu_1}},
\code{\link{queensu_2}},
\code{\link{sfu_brand}},
\code{\link{ubc_1}},
\code{\link{ucalgary_1}},
\code{\link{ucalgary_2}},
\code{\link{ucalgary_accent}},
\code{\link{ucalgary_warmgreys}},
\code{\link{uottawa}},
\code{\link{utoronto}},
\code{\link{uvic_complementary}},
\code{\link{uvic_core}},
\code{\link{uwaterloo_arts}},
\code{\link{uwaterloo_engineering}},
\code{\link{uwaterloo_environment}},
\code{\link{uwaterloo_health}},
\code{\link{uwaterloo_main}},
\code{\link{uwaterloo_math}},
\code{\link{uwaterloo_science}},
\code{\link{western_uni}},
\code{\link{yorku_1}},
\code{\link{yorku_2}}
}
\author{
\strong{unicol}, 2023-06-26.
}
\concept{Canadian university color palettes}
\keyword{datasets}
