% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Carleton.R
\docType{data}
\name{carleton}
\alias{carleton}
\title{Colors of the University of Carleton, Canada}
\format{
An object of class \code{character} of length 2.
}
\source{
Color definitions are based on the
\href{https://www.carleton.edu/communications/resources/college-wordmark-identity-graphics/college-colors/}{University of Carleton's website}.
}
\usage{
carleton
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{carleton} provides the two official colors 
of the \href{https://carleton.ca/}{University of Carleton}, Canada.
}
\details{
The 2 official colors are
\code{maize} (defined as Pantone 122, 
and approximated by RGB 255/223/79, or HEX #FFDF4F), and
\code{blue_carleton} (defined as Pantone 294, 
and approximated by RGB 0/48/105, or HEX #003069).

\code{carleton} uses the HEX color definitions.
}
\examples{
carleton
unikn::seecol(carleton, 
              main = "Colors of the University of Carleton") # view color palette

}
\seealso{
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.

Other Canadian university color palettes: 
\code{\link{conc_1}},
\code{\link{conc_2}},
\code{\link{conc_3}},
\code{\link{conc_4}},
\code{\link{guelph}},
\code{\link{laval}},
\code{\link{manitoba_1}},
\code{\link{manitoba_2}},
\code{\link{mcgill_brights}},
\code{\link{mcgill_darks}},
\code{\link{mcgill_grey}},
\code{\link{mcgill_muted}},
\code{\link{mcgill_pastels}},
\code{\link{mcgill_red}},
\code{\link{mcmaster_brighterworld}},
\code{\link{mcmaster_heritage}},
\code{\link{mun_1}},
\code{\link{mun_2}},
\code{\link{queensu_1}},
\code{\link{queensu_2}},
\code{\link{sfu_brand}},
\code{\link{ubc_1}},
\code{\link{ucalgary_1}},
\code{\link{ucalgary_2}},
\code{\link{ucalgary_accent}},
\code{\link{ucalgary_warmgreys}},
\code{\link{uottawa}},
\code{\link{utoronto}},
\code{\link{uvic_complementary}},
\code{\link{uvic_core}},
\code{\link{uwaterloo_arts}},
\code{\link{uwaterloo_engineering}},
\code{\link{uwaterloo_environment}},
\code{\link{uwaterloo_health}},
\code{\link{uwaterloo_main}},
\code{\link{uwaterloo_math}},
\code{\link{uwaterloo_science}},
\code{\link{western_uni}},
\code{\link{yorku_1}},
\code{\link{yorku_2}}
}
\author{
\strong{unicol}, 2023-07-12.
}
\concept{Canadian university color palettes}
\keyword{datasets}
