% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spheroid.R
\name{coefficientMatrixSpheroids}
\alias{coefficientMatrixSpheroids}
\title{Coefficients for trivariate unfolding}
\usage{
coefficientMatrixSpheroids(
  breaks,
  stype = c("prolate", "oblate"),
  check = TRUE,
  nCores = getOption("par.unfoldr", 1)
)
}
\arguments{
\item{breaks}{list of bin vectors, see \code{\link{setbreaks}}}

\item{stype}{type of spheroid, either "\code{prolate}" or "\code{oblate}"}

\item{check}{logical, whether to run some input checks}

\item{nCores}{number of cpu cores used to compute the coefficients}
}
\value{
numeric 6D array of coefficients
}
\description{
Compute coefficients of the discretized integral equation for unfolding
}
\details{
In order to apply the Expectation Maximization (EM) algorithm to the stereological unfolding procedure for the joint
size-shape-orientation distribution in 3D one first has to compute the coefficients of a discretized integral equation.
This step is the most time consuming part of unfolding and therefore has been separated in its own function and can be called
separately if needed. The number of bin classes for the size, shape and orientation do not need to be the same, but the
given class limits are also used for binning the spatial values. One can define the number of cpu cores by the global option
\code{par.unfoldr} or passing the number of cores \code{nCores} directly to the function.
}
\examples{
\dontrun{
## Comment: Set breaks vector and compute the coefficient matrix 
## for spheroid unfolding
	
options(par.unfoldr=2L)
breaks <- setbreaks(c(6,5,6),maxSize=0.37,kap=1.25)
breaks

P <- coefficientMatrixSpheroids(breaks,check=FALSE)
c(min(P),max(P),sum(P))

}
}
\author{
M. Baaske
}
