% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spheroid.R
\name{simModel3d}
\alias{simModel3d}
\title{Simulate spheroid system}
\usage{
simModel3d(param, cond)
}
\arguments{
\item{param}{parameters}

\item{cond}{condition object}
}
\value{
spheroid system
}
\description{
Simulate a spheroid system by perfect simulation 
 
Simulate a spheroid system by perfect simulation with log normal sizes and transformed
shape parameter, see \code{\link{simSpheroidSystem}}. This function is intended to be a
condensed version of \code{\link{simSpheroidSystem}} just for ease of use of exact 
simulation with random planar orientation of spheroids.
}
\examples{
\dontrun{
	
# directional distribution
rbetaiso <- function(kappa) {
   phi <- runif(1,0,1)*2*pi
   q <- runif(1,0,1)
   theta=acos((1-2*q)/sqrt(kappa*kappa-(1-2*q)*(1-2*q)*(kappa*kappa-1)))
   list("u"=c(sin(theta)*cos(phi),sin(theta)*sin(phi),cos(theta)),
		   "theta"=theta,"phi"=phi)					
}

# no perfect simualtion here for 'rmulti'
# multivariate size distribution and orientation distribution 
rmulti <- function(m,s,kappa) {	
   dir <- rbetaiso(kappa)
   M <- chol(s, pivot = TRUE)
   M <- M[, order(attr(M, "pivot"))]
   x <- exp(matrix(m,nrow=1) +
          matrix(rnorm(ncol(s)), nrow = 1, byrow = TRUE) \%*\%M)
   a <- min(x)
   b <- max(x)
   
   list("a"=a,"b"=b,"u"=dir$u,"shape"=a/b,
        "theta"=dir$theta, "phi"=dir$phi)

}

set.seed(1234)
lam <- 100
box <- list("xrange"=c(0,5),"yrange"=c(0,5),"zrange"=c(0,5))

# joint (user defined random generating function) simualtion
sigma <- matrix(c(0.1,0.1,0.1,0.25), ncol=2)
theta <- list("m"=c(-3.0,-2.0),"s"=sigma,"kappa"=0.5)
S <- simSpheroidSystem(theta,lam,rjoint="rmulti",box=box,pl=101)

# Spheroids with log normal distributed semi-major axis length
# distribution and independent orientation distribution
theta <- list("size"=list("meanlog"=-2.5,"sdlog"=0.5),
              "shape"=list("s"=0.5),
              "orientation"=list("kappa"=1.5))
  
S <- simSpheroidSystem(theta,lam,size="rlnorm",shape="const",orientation="rbetaiso",
		box=box,pl=101)
			   
# log normal, rbeta shape
theta <- list("size"=list("meanlog"=-2.5,"sdlog"=0.5),
			  "shape"=list("a"=1,"b"=2),
		      "orientation"=list("kappa"=1.5))

S <- simSpheroidSystem(theta,lam,size="rlnorm",shape="rbeta",orientation="rbetaiso",
		box=box,pl=101)

# Spheroids of constant sizes, const shape
theta <- list("size"=list(0.25),
              "shape"=list("s"=0.5),
              "orientation"=list("kappa"=1))
S <- simSpheroidSystem(theta,lam,size="const",shape="const",orientation="rbetaiso",
                       box=box,pl=101)

# constant size, rbeta shape			   
theta <- list("size"=list(0.25),
			  "shape"=list("a"=1,"b"=2),
			  "orientation"=list("kappa"=1.5))	  
			   
S <- simSpheroidSystem(theta,lam,size="const",shape="rbeta",orientation="rbetaiso",
					   box=box,pl=101)			   
			   
			   
# Spheroids exact simulation
param <- list("mx"=-1.0,"my"=-2.5, "sdx"=0.15,"sdy"=0.2,"rho"=0.0,"kappa"=1.0)
theta <- list("size"=list("mx"=param$mx,
					      "sdx"=param$sdx,
						  "my"=param$my,
						  "sdy"=param$sdy,
						  "rho"=param$rho),
			  "orientation"=list("kappa"=param$kappa),
			  "shape"=list())

S <- simSpheroidSystem(theta,lam,size="rbinorm",orientation="rbetaiso",box=box,pl=101)	


## show spheroid system 
#cols <- c("#0000FF","#00FF00","#FF0000","#FF00FF","#FFFF00","#00FFFF")
#spheroids3d(S[1:500],box=box, col=cols)

}

}

