% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_diff_df.r
\name{create_diff_df}
\alias{create_diff_df}
\title{Creates the \code{empty_diff_df.csv}}
\usage{
create_diff_df(
  init_filepath,
  date_format,
  freq,
  covariates = FALSE,
  freq_multiplier = FALSE,
  weights = "standard",
  filename = "empty_diff_df.csv",
  filepath = tempdir()
)
}
\arguments{
\item{init_filepath}{A character filepath to the \code{init.csv}.}

\item{date_format}{A character specifying the date format used in the
\code{init.csv}. Call \code{\link[=undid_date_formats]{undid_date_formats()}} to see a list of valid date formats.}

\item{freq}{A character indicating the length of the time periods to be used
when computing the differences in mean outcomes between periods at each
silo. Options are: \code{"yearly"}, \code{"monthly"}, \code{"weekly"}, or \code{"daily"}.}

\item{covariates}{A character vector specifying covariates to be considered
at each silo. If \code{FALSE} (default) uses covariates from the \code{init.csv}.}

\item{freq_multiplier}{A numeric value or \code{FALSE} (default).
Specify if the frequency should be multiplied by a non-zero integer.}

\item{weights}{A character indicating the weighting to use in the case of
common adoption. The \code{"standard"} (default) weight is calculated as
\eqn{w_s = \frac{N_s^{\text{post}}}{N_s^{\text{post}} + N_s^{\text{pre}}}}.
Options are: \code{"standard"}.}

\item{filename}{A character filename for the created CSV file. Defaults to
\code{"empty_diff_df.csv"}}

\item{filepath}{Filepath to save the CSV file. Defaults to \code{tempdir()}.}
}
\value{
A data frame detailing the silo and time combinations for which
differences must be calculated in order to compute the aggregate ATT. A
CSV copy is saved to the specified directory which is then to be sent out
to each silo.
}
\description{
Creates the \code{empty_diff_df.csv} which lists all of the differences that
need to calculated at each silo in order to compute the aggregate ATT.
The \code{empty_diff_df.csv} is then to be sent out to each silo to be filled out.
}
\details{
Ensure that dates in the \code{init.csv} are entered consistently
in the same date format. Call \code{\link[=undid_date_formats]{undid_date_formats()}} to see a list of valid
date formats. Covariates specified when calling \code{create_diff_df()} will
override any covariates specified in the \code{init.csv}.
}
\examples{
file_path <- system.file("extdata/staggered", "init.csv",
                         package = "undidR")
create_diff_df(
  init_filepath = file_path,
  date_format = "yyyy",
  freq = "yearly"
)
unlink(file.path(tempdir(), "empty_diff_df.csv"))
}
