% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umx_round}
\alias{umx_round}
\title{umx_round}
\usage{
umx_round(df, digits = getOption("digits"), coerce = FALSE)
}
\arguments{
\item{df}{a dataframe to round in}

\item{digits}{how many digits to round to (defaults to getOption("digits"))}

\item{coerce}{whether to make the column numeric if it is not (default = FALSE)}
}
\value{
\itemize{
\item \code{\link[=mxModel]{mxModel()}}
}
}
\description{
A version of round() which works on dataframes that contain non-numeric data (or data that cannot be coerced to numeric)
Helpful for dealing with table output that mixes numeric and string types.
}
\examples{
head(umx_round(mtcars, coerce = FALSE))
head(umx_round(mtcars, coerce = TRUE))

}
\references{
\itemize{
\item \url{https://www.github.com/tbates/umx}
}
}
\seealso{
Other Miscellaneous Stats Helpers: \code{\link{FishersMethod}()},
  \code{\link{SE_from_p}()}, \code{\link{oddsratio}()},
  \code{\link{reliability}()}, \code{\link{umxCov2cor}()},
  \code{\link{umxHetCor}()},
  \code{\link{umxWeightedAIC}()},
  \code{\link{umx_apply}()}, \code{\link{umx_cor}()},
  \code{\link{umx_means}()}, \code{\link{umx_r_test}()},
  \code{\link{umx_scale}()}, \code{\link{umx_var}()},
  \code{\link{umx}}
}
\concept{Miscellaneous Stats Helpers}
