% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umx_scale_wide_twin_data}
\alias{umx_scale_wide_twin_data}
\title{Scale wide twin data}
\usage{
umx_scale_wide_twin_data(varsToScale, sep, data, twins = 1:2)
}
\arguments{
\item{varsToScale}{The base names of the variables ("weight" etc.)}

\item{sep}{The suffix that distinguishes each case, e.g. "_T")}

\item{data}{A wide dataframe}

\item{twins}{Legal digits following sep (default 1:2)}
}
\value{
\itemize{
\item dataframe with varsToScale standardized
}
}
\description{
Scale wide data across all twins. You offer up a list of variables to scale, e.g. c("DEP", "bmi")
and the separator (e.g. \code{sep = "_T"}) and twin suffixes e.g. 1:2 that paste together to make
complete variable names: e.g. "DEP_T1" and "DEP_T2".
}
\examples{
data(twinData) 
df = umx_scale_wide_twin_data(data = twinData, varsToScale = c("ht", "wt"), sep = "")
plot(wt1 ~ wt2, data = df)
}
\references{
\itemize{
\item \url{https://www.github.com/tbates/umx}
}
}
\seealso{
umx_scale

Other Twin Data functions: \code{\link{umx_long2wide}()},
  \code{\link{umx_make_TwinData}()},
  \code{\link{umx_nice_data}()},
  \code{\link{umx_residualize}()},
  \code{\link{umx_wide2long}()}, \code{\link{umx}}
}
\concept{Twin Data functions}
