% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_run_modify.R
\name{umxGxE}
\alias{umxGxE}
\title{umxGxE: Implements ACE models with moderation of paths, e.g. by SES.}
\usage{
umxGxE(name = "G_by_E", selDVs, selDefs, dzData, mzData, sep = NULL,
  data = NULL, zyg = "zygosity", digits = 3, lboundACE = NA,
  lboundM = NA, dropMissingDef = TRUE,
  autoRun = getOption("umx_auto_run"), tryHard = c("no", "yes",
  "mxTryHard", "mxTryHardOrdinal", "mxTryHardWideSearch"),
  optimizer = NULL)
}
\arguments{
\item{name}{The name of the model (default= "G_by_E")}

\item{selDVs}{The dependent variable (e.g. "IQ")}

\item{selDefs}{The definition variable (e.g. "SES")}

\item{dzData}{The DZ dataframe containing the Twin 1 and Twin 2 DV and moderator (4 columns)}

\item{mzData}{The MZ dataframe containing the Twin 1 and Twin 2 DV and moderator (4 columns)}

\item{sep}{How to expand selDVs into full names, i.e., "_T" makes "var" -> "var_T1" and "var_T2"}

\item{data}{If provided, dzData and mzData are treated as valid levels of zyg to select() data sets (default = NULL)}

\item{zyg}{If data provided, this column is used to select rows by zygosity (Default = "zygosity")}

\item{digits}{Rounding precision for tables (default 3)}

\item{lboundACE}{If not NA, then lbound the main effects at this value (default = NA, can help to set this to 0)}

\item{lboundM}{If not NA, then lbound the moderator effects at this value (default = NA, can help to set this to 0)}

\item{dropMissingDef}{Whether to automatically drop missing def var rows for the user (default = TRUE). You get a polite note.}

\item{autoRun}{Optionally run the model (default), or just to create it and return without running.}

\item{tryHard}{Optionally tryHard to get the model to converge (Default = 'no'). "yes" uses mxTryHard. Other options: "mxTryHardOrdinal", "mxTryHardWideSearch".}

\item{optimizer}{Optionally set the optimizer (default NULL does nothing)}
}
\value{
\itemize{
\item GxE \code{\link[=mxModel]{mxModel()}}
}
}
\description{
Make a 2-group GxE (moderated ACE) model (Purcell, 2002). GxE interaction studies test the hypothesis that the strength
of genetic (or environmental) influence varies parametrically (usually linear effects on path estimates)
across levels of environment. umxGxE allows detecting,
testing, and visualizing  G xE (or C or E x E) interaction forms.
}
\details{
The following figure the GxE model as a path diagram:

\if{html}{\figure{GxE.png}{options: width="50\%" alt="Figure: GxE.png"}}
\if{latex}{\figure{GxE.pdf}{options: width=7cm}}
}
\examples{
require(umx)
data(twinData) 
umx_set_optimizer("SLSQP")
twinData$age1 = twinData$age2 = twinData$age
selDVs  = "bmi"
selDefs = "age"
mzData  = subset(twinData, zygosity == "MZFF")[100,]
dzData  = subset(twinData, zygosity == "DZFF")[100,]
umx_time("start")
m1 = umxGxE(selDVs= "bmi", selDefs= "age", sep= "", dzData= dzData, mzData= mzData, tryHard= "yes")
umx_time("stop")

\dontrun{
# Select the data on the fly with data= and zygosity levels
m1 = umxGxE(selDVs= "bmi", selDefs= "age", sep="", dzData= "DZFF", mzData= "MZFF", data= twinData)
# Controlling umxSummary
umxSummaryGxE(m1)
umxSummary(m1, location = "topright")
umxSummary(m1, separateGraphs = TRUE)

m2 = umxModify(m1, regex = "am_.*", comparison = TRUE, tryHard = "mxTryHard")

# umxReduce knows how to test all relevant hypotheses for GxE models,
# reporting these in a nice table.
umxReduce(m1)
}
}
\references{
\itemize{
\item Purcell, S. (2002). Variance components models for gene-environment interaction in twin analysis. \emph{Twin Research},
\strong{6}, 554-571. DOI: \href{https://doi.org/10.1375/twin.5.6.554}{10.1375/twin.5.6.554}
}
}
\seealso{
\itemize{
\item \code{\link[=plot]{plot()}}, \code{\link[=umxSummary]{umxSummary()}}, \code{\link[=umxReduce]{umxReduce()}}
}

Other Twin Modeling Functions: \code{\link{power.ACE.test}()},
  \code{\link{umxACE_cov_fixed}()},
  \code{\link{umxACEcov}()}, \code{\link{umxACEv}()},
  \code{\link{umxACE}()}, \code{\link{umxCP}()},
  \code{\link{umxGxE_window}()}, \code{\link{umxGxEbiv}()},
  \code{\link{umxIP}()},
  \code{\link{umxRotate.MxModelCP}()},
  \code{\link{umxSexLim}()}, \code{\link{umxSimplex}()},
  \code{\link{umx}}
}
\concept{Twin Modeling Functions}
