% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.r
\name{umx_print}
\alias{umx_print}
\title{Print tables in a range of formats (markdown default, see \code{\link{umx_set_table_format}} for other formats)
or as a web browser table.}
\usage{
umx_print(x, digits = getOption("digits"), quote = FALSE,
  na.print = "", zero.print = "0", justify = "none", file = c(NA,
  "tmp.html"), suppress = NULL, ...)
}
\arguments{
\item{x}{A data.frame to print (matrices will be coerced to data.frame)}

\item{digits}{The number of decimal places to print (defaults to getOption("digits")}

\item{quote}{Parameter passed to print (defaults to FALSE)}

\item{na.print}{String to replace NA with (default to blank "")}

\item{zero.print}{String to replace 0.000 with  (defaults to "0")}

\item{justify}{Parameter passed to print (defaults to "none")}

\item{file}{whether to write to a file (defaults to NA (no file). Use "tmp.html" to open table in browser.}

\item{suppress}{minimum numeric value to print (default =  NULL, print all values, no matter how small)}

\item{...}{Optional parameters for print}
}
\value{
- A dataframe of text
}
\description{
To aid interpretability of printed tables from OpenMx (and elsewhere)
you can change how NA and zero appear, and suppressing values below a certain cut-off.
By default, Zeros have the decimals suppressed, and NAs are suppressed altogether.
}
\examples{
umx_print(mtcars[1:10,], digits = 2, zero.print = ".", justify = "left")
umx_print(mtcars[1,1:2], digits = 2, zero.print = "")
\dontrun{
umx_print(mtcars[1:10,], file = "tmp.html")
}
}
\seealso{
\code{\link{umx_msg}}, \code{\link{umx_set_table_format}}

Other Miscellaneous Utility Functions: \code{\link{install.OpenMx}},
  \code{\link{qm}}, \code{\link{umxBrownie}},
  \code{\link{umxFactor}}, \code{\link{umxVersion}},
  \code{\link{umx_array_shift}},
  \code{\link{umx_cell_is_on}},
  \code{\link{umx_cont_2_quantiles}},
  \code{\link{umx_find_object}},
  \code{\link{umx_graphviz_rank}}, \code{\link{umx_make}},
  \code{\link{umx_mat2dot}}, \code{\link{umx_msg}},
  \code{\link{umx_open_CRAN_page}}, \code{\link{umx_pad}},
  \code{\link{umx_pb_note}}, \code{\link{umx_scale}},
  \code{\link{umx}}

Other Reporting Functions: \code{\link{loadings.MxModel}},
  \code{\link{tmx_is.identified}}, \code{\link{umxAPA}},
  \code{\link{umxEval}}, \code{\link{umxFactorScores}},
  \code{\link{umxGetParameters}}, \code{\link{umxReduce}},
  \code{\link{umxSummary}}, \code{\link{umxWeightedAIC}},
  \code{\link{umx_APA_model_CI}},
  \code{\link{umx_APA_pval}}, \code{\link{umx_aggregate}},
  \code{\link{umx_names}}, \code{\link{umx_parameters}},
  \code{\link{umx_show_fit_or_comparison}},
  \code{\link{umx_show}}, \code{\link{umx_time}},
  \code{\link{umx}}
}
\concept{Miscellaneous Utility Functions}
\concept{Reporting Functions}
