% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umxACEv.R
\name{umxSummaryACEv}
\alias{umxSummaryACEv}
\alias{umxSummary.MxModel.ACEv}
\title{Shows a compact, publication-style, summary of a variance-based Cholesky ACE model.}
\usage{
umxSummaryACEv(model, digits = 2, file = getOption("umx_auto_plot"),
  comparison = NULL, std = TRUE, showRg = FALSE, CIs = TRUE,
  report = c("markdown", "html"), returnStd = FALSE, extended = FALSE,
  zero.print = ".", ...)
}
\arguments{
\item{model}{an \code{\link{mxModel}} to summarize}

\item{digits}{round to how many digits (default = 2)}

\item{file}{The name of the dot file to write: "name" = use the name of the model.
Defaults to NA = no plot.}

\item{comparison}{you can run mxCompare on a comparison model (NULL)}

\item{std}{Whether to standardize the output (default = TRUE)}

\item{showRg}{= whether to show the genetic correlations (FALSE)}

\item{CIs}{Whether to show Confidence intervals if they exist (T)}

\item{report}{If "html", then open an html table of the results}

\item{returnStd}{Whether to return the standardized form of the model (default = FALSE)}

\item{extended}{how much to report (FALSE)}

\item{zero.print}{How to show zeros (".")}

\item{...}{Other parameters to control model summary}
}
\value{
- optional \code{\link{mxModel}}
}
\description{
Summarize a fitted Cholesky model returned by \code{\link{umxACEv}}. Can control digits, report comparison model fits,
optionally show the Rg (genetic and environmental correlations), and show confidence intervals. the report parameter allows
drawing the tables to a web browser where they may readily be copied into non-markdown programs like Word.
}
\details{
See documentation for RAM models summary here: \code{\link{umxSummary.MxModel}}.

View documentation on the ACE model subclass here: \code{\link{umxSummary.MxModel.ACE}}.

View documentation on the IP model subclass here: \code{\link{umxSummary.MxModel.IP}}.

View documentation on the CP model subclass here: \code{\link{umxSummary.MxModel.CP}}.

View documentation on the GxE model subclass here: \code{\link{umxSummary.MxModel.GxE}}.
}
\examples{
require(umx)
data(twinData)
selDVs = c("bmi1", "bmi2")
mzData <- subset(twinData, zygosity == "MZFF")
dzData <- subset(twinData, zygosity == "DZFF")
m1 = umxACEv(selDVs = selDVs, dzData = dzData, mzData = mzData)
m1 = umxACE(selDVs = selDVs, dzData = dzData, mzData = mzData)
umxSummary(m1)
\dontrun{
umxSummary(m1, file = NA);
umxSummary(m1, file = "name", std = TRUE)
stdFit = umxSummary(m1, returnStd = TRUE)
}
}
\references{
- \url{http://tbates.github.io}, \url{https://github.com/tbates/umx}
}
\seealso{
- \code{\link{umxACEv}}

Other Twin Modeling Functions: \code{\link{plot.MxModel}},
  \code{\link{umxACESexLim}},
  \code{\link{umxACE_cov_fixed}}, \code{\link{umxACEcov}},
  \code{\link{umxACEv}}, \code{\link{umxACE}},
  \code{\link{umxCF_SexLim}}, \code{\link{umxCP}},
  \code{\link{umxGxE_window}}, \code{\link{umxGxE}},
  \code{\link{umxIP}}, \code{\link{umxPlotACEcov}},
  \code{\link{umxPlotCP}}, \code{\link{umxPlotGxE}},
  \code{\link{umxPlotIP}}, \code{\link{umxReduceACE}},
  \code{\link{umxSummaryACEcov}},
  \code{\link{umxSummaryACE}}, \code{\link{umxSummaryCP}},
  \code{\link{umxSummaryGxE}}, \code{\link{umxSummaryIP}},
  \code{\link{umx_long2wide}}, \code{\link{umx_wide2long}},
  \code{\link{umx}}, \code{\link{xmu_twin_check}}

Other Reporting functions: \code{\link{RMSEA.MxModel}},
  \code{\link{RMSEA.summary.mxmodel}}, \code{\link{RMSEA}},
  \code{\link{extractAIC.MxModel}}, \code{\link{loadings}},
  \code{\link{plot.MxModel}},
  \code{\link{residuals.MxModel}},
  \code{\link{umxCI_boot}}, \code{\link{umxCI}},
  \code{\link{umxCompare}}, \code{\link{umxConfint}},
  \code{\link{umxExpCov}}, \code{\link{umxExpMeans}},
  \code{\link{umxFitIndices}}, \code{\link{umxPlotACEcov}},
  \code{\link{umxPlotACEv}}, \code{\link{umxPlotACE}},
  \code{\link{umxPlotCP}}, \code{\link{umxPlotGxE}},
  \code{\link{umxPlotIP}},
  \code{\link{umxSummary.MxModel}},
  \code{\link{umxSummaryACE}}, \code{\link{umx_drop_ok}},
  \code{\link{umx_standardize_RAM}}
}
