% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.r
\name{umx_print}
\alias{umx_print}
\title{umx_print}
\usage{
umx_print(x, digits = getOption("digits"), quote = FALSE, na.print = "",
  zero.print = "0", justify = "none", file = c(NA, "tmp.html"),
  suppress = NULL, ...)
}
\arguments{
\item{x}{A data.frame to print (matrices will be coerced to data.frame)}

\item{digits}{The number of decimal places to print (defaults to getOption("digits")}

\item{quote}{Parameter passed to print (defaults to FALSE)}

\item{na.print}{String to replace NA with (default to blank "")}

\item{zero.print}{String to replace 0.000 with  (defaults to "0")}

\item{justify}{Parameter passed to print (defaults to "none")}

\item{file}{whether to write to a file (defaults to NA (no file). Use "tmp.html" to open as tables in browser.}

\item{suppress}{minimum numeric value to print (default =  NULL, print all values, no matter how small)}

\item{...}{Optional parameters for print}
}
\description{
A helper to aid the interpretability of printed tables from OpenMx (and elsewhere).
Its most useful characteristics are allowing you to change how NA and zero appear.
and supressing values below a certain cut-off.
By default, Zeros have the decimals suppressed, and NAs are suppressed altogether.
}
\examples{
umx_print(mtcars[1:10,], digits = 2, zero.print = ".", justify = "left")
\dontrun{
umx_print(model)
# open in browser
umx_print(mtcars[1:10,], file = "Rout.html")
}
}
\seealso{
Other Utility Functions: \code{\link{qm}},
  \code{\link{umx_find_object}}, \code{\link{umx_grep}},
  \code{\link{umx_msg}}, \code{\link{umx_names}},
  \code{\link{umx_paste_names}}, \code{\link{umx_pb_note}},
  \code{\link{umx_rename}}, \code{\link{umx}}

Other Reporting Functions: \code{\link{loadings.MxModel}},
  \code{\link{umxAPA}}, \code{\link{umxGetParameters}},
  \code{\link{umxSummary}}, \code{\link{umx_APA_pval}},
  \code{\link{umx_aggregate}}, \code{\link{umx_show}},
  \code{\link{umx_time}}, \code{\link{umx}}
}
