% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_run_modify.r
\name{umxFixAll}
\alias{umxFixAll}
\title{umxFixAll: Fix all free parameters}
\usage{
umxFixAll(model, name = "_fixed", run = FALSE, verbose = FALSE)
}
\arguments{
\item{model}{an \code{\link{mxModel}} within which to fix free parameters}

\item{name}{optional new name for the model. if you begin with a _ it will be made a suffix}

\item{run}{whether to fix and re-run the model, or just return it (defaults to FALSE)}

\item{verbose}{whether to mention how many paths were fixed (default is FALSE)}
}
\value{
- the fixed \code{\link{mxModel}}
}
\description{
Fix all free parameters in a model using omxGetParameters()
}
\examples{
require(umx)
data(demoOneFactor)
latents = c("G")
manifests = names(demoOneFactor)
m1 <- umxRAM("OneFactor", data = mxData(cov(demoOneFactor), type = "cov", numObs = 500),
	umxPath(latents, to = manifests),
	umxPath(var = manifests),
	umxPath(var = latents, fixedAt = 1)
)
m2 = umxFixAll(m1, run = TRUE, verbose = TRUE)
mxCompare(m1, m2)
}
\references{
- \url{http://tbates.github.io}, \url{https://github.com/tbates/umx}
}
\seealso{
Other Modify or Compare Models: \code{\link{umxAdd1}},
  \code{\link{umxDrop1}}, \code{\link{umxEquate}},
  \code{\link{umxMI}}, \code{\link{umxSetParameters}},
  \code{\link{umxUnexplainedCausalNexus}},
  \code{\link{umx}}
}
