% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.r
\name{umxCI}
\alias{umxCI}
\title{umxCI}
\usage{
umxCI(model = NULL, which = c("ALL", NA, "list of your making"),
  remove = FALSE, run = c("no", "yes", "if necessary"),
  showErrorCodes = TRUE)
}
\arguments{
\item{model}{The \code{\link{mxModel}} you wish to report \code{\link{mxCI}}s on}

\item{which}{What CIs to add: c("ALL", NA, "list of your making")}

\item{remove}{= FALSE (if set, removes existing specified CIs from the model)}

\item{run}{Whether or not to compute the CIs. Valid values = "no" (default), "yes", "if necessary".}

\item{showErrorCodes}{Whether to show errors (default == TRUE)}
}
\value{
- \code{\link{mxModel}}
}
\description{
umxCI adds mxCI() calls for all free parameters in a model, 
runs the CIs, and reports a neat summary.
}
\details{
This function also reports any problems computing a CI. The codes are standard OpenMx errors and warnings
\itemize{
\item 1: The final iterate satisfies the optimality conditions to the accuracy requested, but the sequence of iterates has not yet converged. NPSOL was terminated because no further improvement could be made in the merit function (Mx status GREEN)
\item 2: The linear constraints and bounds could not be satisfied. The problem has no feasible solution.
\item 3: The nonlinear constraints and bounds could not be satisfied. The problem may have no feasible solution.
\item 4: The major iteration limit was reached (Mx status BLUE).
\item 6: The model does not satisfy the first-order optimality conditions to the required accuracy, and no improved point for the merit function could be found during the final linesearch (Mx status RED)
\item 7: The function derivates returned by funcon or funobj appear to be incorrect.
\item 9: An input parameter was invalid
}

If runCIs is FALSE, the function simply adds CIs to be computed and returns the model.
}
\examples{
require(umx)
data(demoOneFactor)
latents  = c("G")
manifests = names(demoOneFactor)
m1 <- mxModel("One Factor", type = "RAM", 
	manifestVars = manifests, latentVars = latents, 
	mxPath(from = latents, to = manifests),
	mxPath(from = manifests, arrows = 2),
	mxPath(from = latents, arrows = 2, free = FALSE, values = 1.0),
	mxData(cov(demoOneFactor), type = "cov", numObs = 500)
)
m1 = umxRun(m1, setLabels = TRUE, setValues = TRUE)
m1$intervals # none yet list()
m1 = umxCI(m1)
m1$intervals # $G_to_x1
m1 = umxCI(m1, remove = TRUE) # Add CIs for all free parameters, and return model
\dontrun{
umxCI(model, run = "yes") # force update of CIs
# Don't force update of CIs, but if they were just added, then calculate them
umxCI(model, run = "if necessary")
}
}
\references{
- http://www.github.com/tbates/umx/
}
\seealso{
- \code{\link{mxCI}}, \code{\link{umxLabel}}, \code{\link{umxRun}}

Other Reporting functions: \code{\link{RMSEA.MxModel}},
  \code{\link{RMSEA.summary.mxmodel}}, \code{\link{RMSEA}},
  \code{\link{confint.MxModel}},
  \code{\link{extractAIC.MxModel}}, \code{\link{loadings}},
  \code{\link{logLik.MxModel}}, \code{\link{plot.MxModel}},
  \code{\link{residuals.MxModel}},
  \code{\link{umxCI_boot}}, \code{\link{umxCompare}},
  \code{\link{umxExpCov}}, \code{\link{umxExpMeans}},
  \code{\link{umxFitIndices}}, \code{\link{umxPlotACEcov}},
  \code{\link{umxPlotACE}}, \code{\link{umxPlotCP}},
  \code{\link{umxPlotGxE}}, \code{\link{umxPlotIP}},
  \code{\link{umxSummary.MxModel}},
  \code{\link{umxSummaryACE}}, \code{\link{umx_drop_ok}},
  \code{\link{umx_standardize_RAM}}
}

