% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xmu.r
\name{xmuPropagateLabels}
\alias{xmuPropagateLabels}
\title{xmuPropagateLabels (not a user function)}
\usage{
xmuPropagateLabels(model, suffix = "", verbose = TRUE)
}
\arguments{
\item{model}{a model to label}

\item{suffix}{a string to append to each label}

\item{verbose}{whether to say what is being done}
}
\value{
- \code{\link{mxModel}}
}
\description{
You should be calling \code{\link{umxLabel}}.
This function is called by xmuLabel_MATRIX_Model
}
\examples{
require(umx)
data(demoOneFactor)
latents  = c("G")
manifests = names(demoOneFactor)
m1 <- mxModel("One Factor", type = "RAM", 
	manifestVars = manifests, latentVars = latents, 
	mxPath(from = latents, to = manifests),
	mxPath(from = manifests, arrows = 2),
	mxPath(from = latents, arrows = 2, free = FALSE, values = 1.0),
	mxData(cov(demoOneFactor), type = "cov", numObs = 500)
)
m1 = umx:::xmuPropagateLabels(m1, suffix = "MZ")
}
\seealso{
Other xmu internal not for end user: \code{\link{umx_explode_twin_names}},
  \code{\link{xmuHasSquareBrackets}},
  \code{\link{xmuLabel_MATRIX_Model}},
  \code{\link{xmuLabel_Matrix}},
  \code{\link{xmuLabel_RAM_Model}}, \code{\link{xmuMI}},
  \code{\link{xmuMakeDeviationThresholdsMatrices}},
  \code{\link{xmuMakeOneHeadedPathsFromPathList}},
  \code{\link{xmuMakeTwoHeadedPathsFromPathList}},
  \code{\link{xmuMaxLevels}}, \code{\link{xmuMinLevels}},
  \code{\link{xmu_check_levels_identical}},
  \code{\link{xmu_dot_make_paths}},
  \code{\link{xmu_dot_make_residuals}},
  \code{\link{xmu_start_value_list}}
}

