% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.r
\name{plot.MxModel}
\alias{plot.MxModel}
\alias{umxPlot}
\title{Create a graphical figure from an MxModel}
\usage{
\method{plot}{MxModel}(x = NA, std = FALSE, digits = 2, file = "name",
  pathLabels = c("none", "labels", "both"), showFixed = TRUE,
  showMeans = TRUE, resid = c("circle", "line", "none"), ...)
}
\arguments{
\item{x}{An \code{\link{mxModel}} from which to make a path diagram}

\item{std}{Whether to standardize the model (default = FALSE).}

\item{digits}{The number of decimal places to add to the path coefficients}

\item{file}{The name of the dot file to write: NA = none; "name" = use the name of the model}

\item{pathLabels}{Whether to show labels on the paths. both will show both the parameter and the label. ("both", "none" or "labels")}

\item{showFixed}{Whether to show fixed paths (defaults to TRUE)}

\item{showMeans}{Whether to show means}

\item{resid}{How to show residuals and variances default is "circle". Options are "line" & "none"}

\item{...}{Optional parameters}
}
\description{
Create graphical path diagrams from your OpenMx models!
}
\details{
plot() produces SEM diagrams in graphviz format, and relies on DiagrammeR (or a 
graphviz application) to create the image. 
The commercial application Omnigraffle is great for editing these images.

On unix and windows, plot() will create a pdf and open it in your default pdf reader.

If you use umx_set_plot_format("graphviz"), files will open in with a graphviz helper.

\emph{Note:} DiagrammeR is supported out of the box. If you use graphviz, we try and use that app, but YOU HAVE TO INSTALL IT!
On OS X we try and open an app: you may need to associate the \sQuote{.gv}
extension with the graphviz app.
Find the .gv file made by plot, get info (cmd-I), then choose \dQuote{open with}, 
select Graphviz.app (or OmniGraffle professional),
then set \dQuote{change all}.
}
\examples{
require(umx)
data(demoOneFactor)
latents  = c("G")
manifests = names(demoOneFactor)
m1 <- umxRAM("One Factor", data = mxData(cov(demoOneFactor), type = "cov", numObs = 500),
	umxPath(latents, to = manifests),
	umxPath(var = manifests),
	umxPath(var = latents, fixedAt = 1.0)
)
plot(m1)
}
\references{
- \url{http://www.github.com/tbates/umx}, \url{https://en.wikipedia.org/wiki/DOT_(graph_description_language)}
}
\seealso{
- \code{\link{umx_set_plot_format}}

Other Reporting functions: \code{\link{RMSEA.MxModel}},
  \code{\link{RMSEA.summary.mxmodel}}, \code{\link{RMSEA}},
  \code{\link{confint.MxModel}},
  \code{\link{extractAIC.MxModel}}, \code{\link{loadings}},
  \code{\link{logLik.MxModel}},
  \code{\link{residuals.MxModel}},
  \code{\link{umxCI_boot}}, \code{\link{umxCI}},
  \code{\link{umxCompare}}, \code{\link{umxExpCov}},
  \code{\link{umxExpMeans}}, \code{\link{umxFitIndices}},
  \code{\link{umxPlotACEcov}}, \code{\link{umxPlotACE}},
  \code{\link{umxSummary.MxModel}},
  \code{\link{umxSummaryACE}}, \code{\link{umx_drop_ok}},
  \code{\link{umx_standardize_RAM}}
}

