% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.r
\name{umx_drop_ok}
\alias{umx_drop_ok}
\title{umx_drop_ok}
\usage{
umx_drop_ok(model1, model2, text = "parameter")
}
\arguments{
\item{model1}{the base code{\link{mxModel}}}

\item{model2}{the nested code{\link{mxModel}}}

\item{text}{name of the thing being tested, i.e., "Extraversion" or "variances"}
}
\value{
-
}
\description{
Print a meaningful sentence about a model comparison. If you use this, please email me and ask to have it
merged with \code{\link{umxCompare}}() :-)
}
\examples{
require(umx)
data(demoOneFactor)
latents   = c("g")
manifests = names(demoOneFactor)
myData    = mxData(cov(demoOneFactor), type = "cov", numObs = 500)
m1 <- umxRAM("OneFactor", data = myData,
	umxPath(latents, to = manifests),
	umxPath(var = manifests),
	umxPath(var = latents, fixedAt = 1)
)
m2 = umxModify(m1, update = "g_to_x1", name = "no effect on x1")
umx_drop_ok(m1, m2, text = "the path to x1")
}
\references{
- \url{http://tbates.github.io}, \url{https://github.com/tbates/umx}
}
\seealso{
Other Reporting functions: \code{\link{RMSEA.MxModel}},
  \code{\link{RMSEA.summary.mxmodel}}, \code{\link{RMSEA}},
  \code{\link{confint.MxModel}},
  \code{\link{extractAIC.MxModel}}, \code{\link{loadings}},
  \code{\link{logLik.MxModel}}, \code{\link{plot.MxModel}},
  \code{\link{residuals.MxModel}},
  \code{\link{umxCI_boot}}, \code{\link{umxCI}},
  \code{\link{umxCompare}}, \code{\link{umxExpCov}},
  \code{\link{umxExpMeans}}, \code{\link{umxFitIndices}},
  \code{\link{umxPlotACEcov}}, \code{\link{umxPlotACE}},
  \code{\link{umxSummary.MxModel}},
  \code{\link{umxSummaryACE}},
  \code{\link{umx_standardize_RAM}}
}

