% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.r
\name{umx_default_option}
\alias{umx_default_option}
\title{umx_default_option}
\usage{
umx_default_option(x, option_list, check = TRUE)
}
\arguments{
\item{x}{the value chosen (may be the default option list)}

\item{option_list}{A vector of valid options}

\item{check}{Whether to check that single items are in the list. Set false to accept abbreviations (defaults to TRUE)}
}
\value{
- one validated option
}
\description{
Handle parameter options given as a default list in a function.
This is just a version of x = \code{\link{match.arg}}(x) which
allows items not in the list.
}
\examples{
\dontrun{
option_list = c("default", "par.observed", "empirical")
umx_default_option("par.observed", option_list)
umx_default_option("bad", option_list)
umx_default_option("allow me", option_list, check = FALSE)
umx_default_option(option_list, option_list)
option_list = c(NULL, "par.observed", "empirical")
umx_default_option(option_list, option_list) # fails with NULL!!!!!
option_list = c(NA, "par.observed", "empirical")
umx_default_option(option_list, option_list) # use NA instead
option_list = c(TRUE, FALSE, NA)
umx_default_option(option_list, option_list) # works with non character
}
}
\references{
- \url{http://www.github.com/tbates/umx}
}
\seealso{
- \code{\link{match.arg}}

Other Misc: \code{\link{umxEval}},
  \code{\link{umx_APA_model_CI}},
  \code{\link{umx_add_variances}}, \code{\link{umx_apply}},
  \code{\link{umx_get_bracket_addresses}},
  \code{\link{umx_object_as_str}},
  \code{\link{umx_string_to_algebra}}, \code{\link{umx}}
}

