% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_run_modify.r
\docType{package}
\name{umx}
\alias{umx}
\alias{umx-package}
\title{Helper Functions for Structural Equation Modelling in OpenMx}
\description{
umx allows you to more easily build, run, modify, and report models using OpenMx
with code. The core functions are linked below under \strong{See Also}
}
\details{
The functions are organized into families: Have a read of these below, click to explore.

All the functions have explanatory examples, so use the help, even if you think it won't help :-)
Have a look, for example at \code{\link{umxRAM}}

Introductory working examples are below. You can run all demos with demo(umx)
When I have a vignette, it will be: vignette("umx", package = "umx")

The development version of umx is github \url{http://github.com/tbates/umx}

There is a helpful blog at \url{http://tbates.github.io}

To install from github, use:
install.packages("devtools")
library("devtools")
install_github("tbates/umx")
library("umx")
}
\examples{
require("umx")
data(demoOneFactor)
myData = mxData(cov(demoOneFactor), type = "cov", numObs = nrow(demoOneFactor))
latents = c("G")
manifests = names(demoOneFactor)
m1 <- mxModel("One Factor", type = "RAM",
	manifestVars = manifests,
	latentVars  = latents,
	mxPath(from = latents, to = manifests),
	mxPath(from = manifests, arrows = 2),
	mxPath(from = latents  , arrows = 2, free = FALSE, values = 1),
	myData
)

omxGetParameters(m1) # nb: By default, paths have no labels, and starts of 0

# With \\code{link{umxLabel}}, you can easily add informative and predictable labels to each free
# path (works with matrix style as well!) and use \\code{link{umxValues}}, to set 
# sensible guesses for start values...
m1 = umxLabel(m1)  
m1 = umxValues(m1)  

# nb: ?mxRAM simplifies model making in several ways. Check it out!

# Re-run omxGetParameters...
omxGetParameters(m1) # Wow! Now your model has informative labels, & better starts

m1 = mxRun(m1) # not needed given we've done this above.

# Let's get some journal-ready fit information

umxSummary(m1) 
umxSummary(m1, show = "std") #also display parameter estimates 
# You can get the coefficients of an MxModel with coef(), just like for lm etc.
coef(m1)

# ==================
# = Model updating =
# ==================
# Can we set the loading of X5 on G to zero?
m2 = omxSetParameters(m1, labels = "G_to_x1", values = 0, free = FALSE, name = "no_g_on_X5")
m2 = mxRun(m2)
# Compare the two models
umxCompare(m1, m2)

# Use umxReRun to do the same thing in 1-line
m2 = umxReRun(m1, "G_to_x1", name = "no_effect_of_g_on_X5", comparison = TRUE)

# =================================
# = Get some Confidence intervals =
# =================================

confint(m1, run = TRUE) # lots more to learn about ?confint.MxModel

# And make a Figure it dot format!
# If you have installed GraphViz, the next command will open it for you to see!

# umxPlot(m1, std = TRUE)
# Run this instead if you don't have GraphViz
plot(m1, std = TRUE, dotFilename = NA)
}
\references{
- \url{http://www.github.com/tbates/umx}
}
\seealso{
Other Data Functions: \code{\link{umxCovData}},
  \code{\link{umxFactor}}, \code{\link{umxHetCor}},
  \code{\link{umxPadAndPruneForDefVars}},
  \code{\link{umx_as_numeric}},
  \code{\link{umx_cont_2_ordinal}},
  \code{\link{umx_cov2raw}}, \code{\link{umx_lower2full}},
  \code{\link{umx_make_bin_cont_pair_data}},
  \code{\link{umx_merge_CIs}},
  \code{\link{umx_read_lower}}, \code{\link{umx_reorder}},
  \code{\link{umx_residualize}}, \code{\link{umx_round}},
  \code{\link{umx_scale_wide_twin_data}},
  \code{\link{umx_scale}}, \code{\link{umx_swap_a_block}}

Other File Functions: \code{\link{dl_from_dropbox}},
  \code{\link{umx_move_file}}, \code{\link{umx_open}},
  \code{\link{umx_rename_file}}

Other Misc: \code{\link{umxEval}},
  \code{\link{umx_APA_model_CI}},
  \code{\link{umx_add_variances}}, \code{\link{umx_apply}},
  \code{\link{umx_default_option}},
  \code{\link{umx_get_bracket_addresses}},
  \code{\link{umx_object_as_str}},
  \code{\link{umx_string_to_algebra}}

Other Model Building Functions: \code{\link{umxDiagnose}},
  \code{\link{umxLabel}}, \code{\link{umxLatent}},
  \code{\link{umxPath}}, \code{\link{umxRAM}},
  \code{\link{umxReRun}}, \code{\link{umxRun}},
  \code{\link{umxThresholdMatrix}},
  \code{\link{umxValues}},
  \code{\link{umx_fix_first_loadings}},
  \code{\link{umx_fix_latents}}

Other Modify or Compare Models: \code{\link{umxAdd1}},
  \code{\link{umxDrop1}}, \code{\link{umxEquate}},
  \code{\link{umxFixAll}}, \code{\link{umxGetParameters}},
  \code{\link{umxMI}}, \code{\link{umxSetParameters}},
  \code{\link{umxUnexplainedCausalNexus}}

Other Reporting Functions: \code{\link{summaryAPA}},
  \code{\link{umx_APA_pval}}, \code{\link{umx_aggregate}},
  \code{\link{umx_print}}, \code{\link{umx_show}},
  \code{\link{umx_time}}

Other Stats Functions: \code{\link{reliability}},
  \code{\link{umxCov2cor}}, \code{\link{umx_cor}},
  \code{\link{umx_means}}

Other Super-easy helpers: \code{\link{umxEFA}},
  \code{\link{umxJiggle}}

Other Twin Modeling Functions: \code{\link{umxACESexLim}},
  \code{\link{umxACE}}, \code{\link{umxCF_SexLim}},
  \code{\link{umxCP}}, \code{\link{umxGxE_window}},
  \code{\link{umxGxE}}, \code{\link{umxIP}},
  \code{\link{umxPlotCP}}, \code{\link{umxPlotGxE}},
  \code{\link{umxSummaryACE}}, \code{\link{umxSummaryCP}},
  \code{\link{umxSummaryGxE}}, \code{\link{umxSummaryIP}}

Other Utility Functions: \code{\link{qm}},
  \code{\link{umx_find_object}}, \code{\link{umx_grep}},
  \code{\link{umx_msg}}, \code{\link{umx_names}},
  \code{\link{umx_paste_names}}, \code{\link{umx_pb_note}},
  \code{\link{umx_print}}, \code{\link{umx_rename}}

Other zAdvanced Helpers: \code{\link{umx_RAM_ordinal_objective}},
  \code{\link{umx_standardize_ACE}},
  \code{\link{umx_standardize_CP}},
  \code{\link{umx_standardize_IP}}
}

