% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/fit_and_reporting.r
\name{umx_APA_CI}
\alias{umx_APA_CI}
\title{umx_APA_CI}
\usage{
umx_APA_CI(b, se, digits = 3)
}
\arguments{
\item{b}{Either a model (\link{lm}), or a beta-value}

\item{se}{If b is a model, then name of the parameter of interest, else the SE (standard-error)}

\item{digits}{How many digits to use in rounding values}
}
\value{
- string
}
\description{
Given an lm, will return a nicely-formated effect including 95\% CI
in square brackets, for one of the effects (specified by name in se). e.g.:

\code{\link{umx_APA_CI}}(m1, "wt")
\eqn{\beta} = -5.344 [-6.486, -4.203], p< 0.001

Given b and se will return a CI based on 1.96 times the se.
}
\examples{
umx_APA_CI(lm(mpg ~ wt, mtcars), "wt")
umx_APA_CI(.4, .3)
}
\references{
- \url{https://github.com/tbates/umx}, \url{https://tbates.github.io}
}
\seealso{
Other Reporting Functions: \code{\link{umxStandardizeACE}};
  \code{\link{umxSummary.MxModel.CP}},
  \code{\link{umxSummaryCP}}; \code{\link{umx_APA_pval}};
  \code{\link{umx_aggregate}}; \code{\link{umx_print}};
  \code{\link{umx_show}}; \code{\link{umx_time}};
  \code{\link{umx}}, \code{\link{umx-package}}
}

