% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/build_run_modify.r
\name{umxGxE_window}
\alias{umxGxE_window}
\title{umxGxE_window}
\usage{
umxGxE_window(selDVs = NULL, moderator = NULL, mzData = mzData,
  dzData = dzData, weightCov = FALSE, target = NULL, width = 1,
  plotWindow = FALSE, return = c("estimates", "last_model"))
}
\arguments{
\item{selDVs}{The dependent variables for T1 and T2, e.g. c("bmi_T1", "bmi_T2")}

\item{moderator}{The name of the moderator variable in the dataset e.g. "age", "SES" etc.}

\item{mzData}{Dataframe containing the DV and moderator for MZ twins}

\item{dzData}{Dataframe containing the DV and moderator for DZ twins}

\item{weightCov}{Whether to use cov.wt matrices or FIML default = FALSE, i.e., FIML}

\item{target}{A user-selected list of moderator values to test (default = NULL = explore the full range)}

\item{width}{An option to widen or narrow the window from its default (of 1)}

\item{plotWindow}{whether to plot what the window looks like}

\item{return}{whether to return the last model (useful for specifiedTargets) or the list of estimates (default = "estimates")}
}
\value{
- Table of estimates of ACE along the moderator
}
\description{
Makes a model to do a GxE analysis using Local SEM (Hildebrandt, Wilhelm & Robitzsch, 2009, p96)
Local SEM GxE relies on weighting the moderator to allow conducting repeated regular
ACE analyses targeted at sucessive regions of the moderator.
In this sense, you can think of it as nonparametric GxE
}
\examples{
library(OpenMx);
# ==============================
# = 1. Open and clean the data =
# ==============================
# umxGxE_window takes a dataframe consisting of a moderator and two DV columns: one for each twin
mod = "age"         # The name of the moderator column in the dataset
selDVs = c("bmi1", "bmi2") # The DV for twin 1 and twin 2
data(twinData) # Dataset of Australian twins, built into OpenMx
# The twinData consist of two cohorts. First we label them
# TODO: Q for OpenMx team: can I add a cohort column to this dataset?
twinData$cohort = 1; twinData$cohort[twinData$zyg \%in\% 6:10] = 2
twinData$zyg[twinData$cohort == 2] = twinData$zyg[twinData$cohort == 2]-5
# And set a plain-English label
labList = c("MZFF", "MZMM", "DZFF", "DZMM", "DZOS")
twinData$ZYG = factor(twinData$zyg, levels = 1:5, labels = labList)
# The model also assumes two groups: MZ and DZ. Moderator can't be missing
# Delete missing moderator rows
twinData = twinData[!is.na(twinData[mod]),]
mzData = subset(twinData, ZYG == "MZFF", c(selDVs, mod))
dzData = subset(twinData, ZYG == "DZFF", c(selDVs, mod))

# ========================
# = 2. Run the analyses! =
# ========================
# Run and plot for specified windows (in this case just 1927)
umxGxE_window(selDVs = selDVs, moderator = mod, mzData = mzData, dzData = dzData,
		target = 40, plotWindow = TRUE)

\dontrun{
# Run with FIML (default) uses all information
umxGxE_window(selDVs = selDVs, moderator = mod, mzData = mzData, dzData = dzData);

# Run creating weighted covariance matrices (excludes missing data)
umxGxE_window(selDVs = selDVs, moderator = mod, mzData = mzData, dzData = dzData,
		weightCov = TRUE);
}
}
\references{
- Hildebrandt, A., Wilhelm, O, & Robitzsch, A. (2009)
Complementary and competing factor analytic approaches for the investigation
of measurement invariance. \emph{Review of Psychology}, \bold{16}, 87--107.

Briley, D.A., Harden, K.P., Bates, T.C.,  Tucker-Drob, E.M. (2015).
Nonparametric Estimates of Gene x Environment Interaction Using Local Structural Equation Modeling.
\emph{Behavior Genetics}.
}
\seealso{
Other Twin Modeling Functions: \code{\link{umxACE}};
  \code{\link{umx}}, \code{\link{umx-package}}
}

