% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/fit_and_reporting.r
\name{umxFitIndices}
\alias{umxFitIndices}
\title{umxFitIndices}
\usage{
umxFitIndices(model, indepfit)
}
\arguments{
\item{model}{the \code{\link{mxModel}} you want fit indices for}

\item{indepfit}{an (optional) saturated \code{\link{mxModel}}}
}
\value{
\code{NULL}
}
\description{
A list of fit indices
}
\examples{
require(OpenMx)
data(demoOneFactor)
latents  = c("G")
manifests = names(demoOneFactor)
m1 <- mxModel("One Factor", type = "RAM",
	manifestVars = manifests, latentVars = latents,
	mxPath(from = latents, to = manifests),
	mxPath(from = manifests, arrows = 2),
	mxPath(from = latents, arrows = 2, free = FALSE, values = 1.0),
	mxData(cov(demoOneFactor), type = "cov", numObs = 500)
)
m1 = umxRun(m1, setLabels = TRUE, setValues = TRUE)
\dontrun{
umxFitIndices(m1)
}
}
\references{
- \url{http://www.github.com/tbates/umx}
}
\seealso{
Other Reporting functions: \code{\link{RMSEA.MxModel}};
  \code{\link{RMSEA.summary.mxmodel}}; \code{\link{RMSEA}};
  \code{\link{coef.MxModel}};
  \code{\link{confint.MxModel}};
  \code{\link{extractAIC.MxModel}};
  \code{\link{logLik.MxModel}}; \code{\link{plot.MxModel}},
  \code{\link{umxPlot}}; \code{\link{plot}},
  \code{\link{plot.MxModel.ACE}}, \code{\link{umxPlotACE}};
  \code{\link{residuals.MxModel}};
  \code{\link{umxCI_boot}}; \code{\link{umxCI}};
  \code{\link{umxCompare}}; \code{\link{umxExpCov}};
  \code{\link{umxExpMeans}};
  \code{\link{umxStandardizeModel}};
  \code{\link{umxSummary.MxModel}};
  \code{\link{umx_drop_ok}}
}

