% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/udpipe_parse.R
\name{as.data.frame.udpipe_connlu}
\alias{as.data.frame.udpipe_connlu}
\title{Convert the result of udpipe_annotate to a tidy data frame}
\usage{
\method{as.data.frame}{udpipe_connlu}(x, ...)
}
\arguments{
\item{x}{an object of class \code{udpipe_connlu} as returned by \code{\link{udpipe_annotate}}}

\item{...}{currently not used}
}
\value{
a data.frame with columns doc_id, paragraph_id, sentence_id, sentence, 
token_id, token, lemma, upos, xpos, feats, head_token_id, deprel, dep_rel, misc \cr

The columns paragraph_id, sentence_id are integers, the other fields
are character data in UTF-8 encoding. \cr
}
\description{
Convert the result of \code{\link{udpipe_annotate}} to a tidy data frame
}
\examples{
x <- udpipe_download_model(language = "dutch-lassysmall")
ud_dutch <- udpipe_load_model(x$file_model)
txt <- c("Ik ben de weg kwijt, kunt u me zeggen waar de Lange Wapper ligt? Jazeker meneer", 
         "Het gaat vooruit, het gaat verbazend goed vooruit")
x <- udpipe_annotate(ud_dutch, x = txt)
x <- as.data.frame(x)
head(x)


## cleanup for CRAN only - you probably want to keep your model if you have downloaded it
file.remove("dutch-lassysmall-ud-2.0-170801.udpipe")
}
\seealso{
\code{\link{udpipe_annotate}}
}
