% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ubiquity.R
\name{system_set_tt_bolus}
\alias{system_set_tt_bolus}
\title{Actual Function Called by \code{SI_TT_BOLUS}}
\usage{
system_set_tt_bolus(cfg, state, values, times, tt_ts, tsinfo,
  repdose = "none", interval = 1, number = 0)
}
\arguments{
\item{cfg}{ubiquity system object}

\item{state}{dosing state/compartment (Defined in \code{<B:events>})}

\item{values}{vector of dosing amounts (in dosing units defined by \code{<B:events>})}

\item{times}{vector of dosing times relative to the current titration time (in # time units defiend by \code{<B:times>})}

\item{tt_ts}{list of timescale values for the current titration time}

\item{tsinfo}{list with timescale information for inputs (bolus, rates, etc)}

\item{repdose}{\code{"none"}, \code{"last"}, \code{"all"}}

\item{interval}{interval to repeat in the units defined in \code{<B:times>}}

\item{number}{number of times to repeat}
}
\value{
ubiquity system object with the bolus dosing updated.
}
\description{
The prototype function \code{SI_TT_BOLUS} provides an interface to this function. Based on the input from \code{SI_TT_BOLUS}
bolus inputs will be updated for the current titration time.
}
\keyword{internal}
