% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/a_tubfs.R
\name{summary.tuts_BFS}
\alias{summary.tuts_BFS}
\title{Prints summary tables of tuts_BFS objects}
\usage{
\method{summary}{tuts_BFS}(object, ...)
}
\arguments{
\item{object}{A tuts_BFS object.}

\item{...}{A list of optional parameters: \cr
- burn: burn-in parameter ranging from 0 to 0.7, the default value is 0.\cr
- CI: confidence interval, the default value is set to 0.99.}
}
\description{
\code{summary.tuts_BFS} prints summary tables of tuts_BFS objects
}
\examples{
# Note: Most of models included in tuts package are computationally intensive. In the example
# below I set parameters to meet CRAN’s testing requirement of maximum 5 sec per example.
# A more practical example would contain N=50 in the first line of the code and n.sim=10000.

#1. Import or simulate the data (a simulation is chosen for illustrative purposes):
DATA=simtuts(N=8,Harmonics=c(4,0,0), sin.ampl=c(10,0, 0), cos.ampl=c(0,0,0),
            trend=0,y.sd=2, ti.sd=0.2)
y=DATA$observed$y.obs
ti.mu=DATA$observed$ti.obs.tnorm
ti.sd= rep(0.2, length(ti.mu))

#2. Fit the model:
n.sim=10
BFS=tubfs(y=y,ti.mu=ti.mu,ti.sd=ti.sd,freqs='internal',n.sim=n.sim,n.chains=2, CV=FALSE)

#3. Generate summary results (optional parameters are listed in brackets):
summary(BFS)                               # Summary results (CI, burn).
summary(BFS,burn=0.2)                      # Results after 20\% of burn-in (CI).
}
