% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logging.R
\name{message_wrap}
\alias{message_wrap}
\title{Write a message that respects the line width}
\usage{
message_wrap(
  x,
  width = options()$width - 2,
  prefix = "",
  color_text = NULL,
  color_prefix = color_text
)
}
\arguments{
\item{x}{A character string of the message text.}

\item{width}{An integer for the width.}

\item{prefix}{An optional string to go on the first line of the message.}

\item{color_text, color_prefix}{A function (or \code{NULL}) that is used to color
the text and/or prefix.}
}
\value{
The processed text is returned (invisibly) but a message is written.
}
\description{
Write a message that respects the line width
}
\examples{
library(cli)
Gaiman <-
  paste(
    '"Good point." Bod was pleased with himself, and glad he had thought of',
    'asking the poet for advice. Really, he thought, if you couldn\'t trust a',
    'poet to offer sensible advice, who could you trust?',
    collapse = ""
  )
message_wrap(Gaiman)
message_wrap(Gaiman, width = 20, prefix = "-")
message_wrap(Gaiman, width = 30, prefix = "-",
             color_text = cli::col_silver)
message_wrap(Gaiman, width = 30, prefix = "-",
             color_text = cli::style_underline,
             color_prefix = cli::col_green)
}
