% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vr.R
\name{vr}
\alias{vr}
\title{Compute the classic or Loreau-de Mazancourt variance ratio}
\usage{
vr(X, method = "classic")
}
\arguments{
\item{X}{A matrix with counts or densities arranged in species by time steps}

\item{method}{If \code{"classic"} (default), use the classical method. If \code{"LdM"}, use the 
Loreau-de Mazancourt method (see reference).}
}
\value{
\code{vr} returns the value of variance ratio
}
\description{
This function is used to compute the classical or Loreau-de Mazancourt variance ratio 
for a community in a single plot.
}
\examples{
X<-matrix(runif(200,1,100), 10, 20)
vr(X, method="LdM")
vr(X, method="classic")

}
\references{
Loreau & Mazancourt, Species Synchrony and Its Drivers: Neutral and Nonneutral Community 
Dynamics in Fluctuating Environments. 2008, Am. Nat. 172(2)

Zhao et al, (In prep) Decomposition of the variance ratio illuminates timescale-specific
population and community variability.

Peterson, Stability of species and of community for the benthos of two lagoons. 1975,
Ecology, 56, 958-965.
}
\seealso{
\code{\link{vrf}}, \code{\link{vreq}}, \code{\link{vreq_classic}}, \code{\link{vreq_LdM}},
\code{browseVignettes("tsvr")}
}
\author{
Lei Zhao, \email{lei.zhao@cau.edu.cn}; Daniel Reuman, \email{reuman@ku.edu}
}
