% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time-wise.R
\name{difference}
\alias{difference}
\title{Lagged differences}
\usage{
difference(x, lag = 1, differences = 1, default = NA, order_by = NULL)
}
\arguments{
\item{x}{A vector}

\item{lag}{A positive integer indicating which lag to use.}

\item{differences}{A positive integer indicating the order of the difference.}

\item{default}{The value used to pad \code{x} back to its original size after the
lag or lead has been applied. The default, \code{NULL}, pads with a missing
value. If supplied, this must be a vector with size 1, which will be cast
to the type of \code{x}.}

\item{order_by}{An optional secondary vector that defines the ordering to use
when applying the lag or lead to \code{x}. If supplied, this must be the same
size as \code{x}.}
}
\value{
A numeric vector of the same length as \code{x}.
}
\description{
\lifecycle{stable}
}
\examples{
# examples from base
difference(1:10, 2)
difference(1:10, 2, 2)
x <- cumsum(cumsum(1:10))
difference(x, lag = 2)
difference(x, differences = 2)
# Use order_by if data not already ordered (example from dplyr)
library(dplyr, warn.conflicts = FALSE)
tsbl <- tsibble(year = 2000:2005, value = (0:5)^2, index = year)
scrambled <- tsbl \%>\% slice(sample(nrow(tsbl)))

wrong <- mutate(scrambled, diff = difference(value))
arrange(wrong, year)

right <- mutate(scrambled, diff = difference(value, order_by = year))
arrange(right, year)
}
\seealso{
\link[dplyr:lead-lag]{dplyr::lead} and \link[dplyr:lead-lag]{dplyr::lag}
}
