% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slide.R
\name{future_slide()}
\alias{future_slide()}
\title{Sliding window in parallel}
\description{
\lifecycle{questioning}

\strong{The rolling window family will be deprecated in the future. Please consider
using the \href{https://davisvaughan.github.io/slider}{slider} package.}

Multiprocessing equivalents of \code{\link[=slide]{slide()}}, \code{\link[=tile]{tile()}}, \code{\link[=stretch]{stretch()}} prefixed by \code{future_}.
\itemize{
\item Variants for corresponding types: \verb{future_*_lgl()}, \verb{future_*_int()},
\verb{future_*_dbl()}, \verb{future_*_chr()}, \verb{future_*_dfr()}, \verb{future_*_dfc()}.
\item Extra arguments \code{.progress} and \code{.options} for enabling progress bar and the
future specific options to use with the workers.
}
}
\details{
It requires the package \strong{furrr} to be installed. Please refer to \href{https://davisvaughan.github.io/furrr/}{furrr} for performance and detailed usage.
}
\examples{
if (!requireNamespace("furrr", quietly = TRUE)) {
  stop("Please install the furrr package to run these following examples.")
}
\dontrun{
library(furrr)
plan(multiprocess)
my_diag <- function(...) {
  data <- list(...)
  fit <- lm(Count ~ Time, data = data)
  tibble(fitted = fitted(fit), resid = residuals(fit))
}
pedestrian \%>\%
  group_by_key() \%>\%
  nest() \%>\%
  mutate(diag = future_map(data, ~ future_pslide_dfr(., my_diag, .size = 48)))
}
# nocov start
}
\alias{future_slide}
\alias{future_slide2}
\alias{future_pslide}
\alias{future_slide_lgl}
\alias{future_slide_chr}
\alias{future_slide_int}
\alias{future_slide_dbl}
\alias{future_slide_dfr}
\alias{future_slide_dfc}
\alias{future_slide2_lgl}
\alias{future_slide2_chr}
\alias{future_slide2_int}
\alias{future_slide2_dbl}
\alias{future_slide2_dfr}
\alias{future_slide2_dfc}
\alias{future_pslide_lgl}
\alias{future_pslide_chr}
\alias{future_pslide_int}
\alias{future_pslide_dbl}
\alias{future_pslide_dfr}
\alias{future_pslide_dfc}
