% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compengine.R
\name{autocorr_features}
\alias{autocorr_features}
\title{The autocorrelation feature set from software package \code{hctsa}}
\usage{
autocorr_features(x)
}
\arguments{
\item{x}{the input time series}
}
\value{
a vector with autocorrelation features
}
\description{
Calculate the features that grouped as autocorrelation set,
which have been used in CompEngine database, using method introduced in package \code{kctsa}.
}
\details{
Features in this set are \code{embed2_incircle_1},
\code{embed2_incircle_2},
\code{ac_9},
\code{firstmin_ac},
\code{trev_num},
\code{motiftwo_entro3},
and \code{walker_propcross}.
}
\references{
B.D. Fulcher and N.S. Jones. hctsa: A computational framework for automated time-series phenotyping using massive feature extraction. Cell Systems 5, 527 (2017).

B.D. Fulcher, M.A. Little, N.S. Jones Highly comparative time-series analysis: the empirical structure of time series and their methods. J. Roy. Soc. Interface 10, 83 (2013).
}
\seealso{
\code{\link{embed2_incircle}}

\code{\link{ac_9}}

\code{\link{firstmin_ac}}

\code{\link{trev_num}}

\code{\link{motiftwo_entro3}}

\code{\link{walker_propcross}}
}
\author{
Yangzhuoran Yang
}
