% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ca-classes-methods.r
\name{constructive_aggregation}
\alias{constructive_aggregation}
\title{Constructive aggregation constructor}
\usage{
constructive_aggregation(form, data, specs, lambda = 100, alpha = 30,
  depth = NULL, aggregate_subsets = "simple",
  aggregate_hypos = "simple")
}
\arguments{
\item{form}{formula}

\item{data}{training data}

\item{specs}{object of class \code{\link{model_specs-class}}. Contains
the parameter setting information for training the
base models;}

\item{lambda}{smoothing window size}

\item{alpha}{contiguity interval size}

\item{depth}{depth size how large is the maximum size
of the subsets. If NULL, defaults to no. of predictors
minus one.}

\item{aggregate_subsets}{aggregation approach for the
set of subsets.}

\item{aggregate_hypos}{final aggregation approach. How should the
combined opinions be aggregated.}
}
\description{
Constructive aggregation via out-performance contiguity
This method denotes the idea of rearranging a portfolio of
models (\strong{base_ensemble}) into different overlapping
subsets. These subsets are aggregated (\strong{aggregate_subsets})
into combined opinions, forming new models. These models
are combined into a final decision through \strong{aggregate_hypos}.
}
\examples{
specs <- model_specs(
  learner = c("bm_svr", "bm_mars"),
  learner_pars = list(
    bm_glm = list(alpha = c(0, .5, 1)),
    bm_svr = list(kernel = c("rbfdot"),
                  C = c(1, 3))
  )
)

data("water_consumption")
waterc <- embed_timeseries(water_consumption, 5)
train <- waterc[1:300, ] # toy size for checks
test  <- waterc[301:320, ] # toy size for checks

model <- constructive_aggregation(target ~., train, specs, 10,5,NULL,"window_loss","simple")
preds <- predict(model, test)

}
