% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimation.R
\name{estimate.tsdistribution.spec}
\alias{estimate.tsdistribution.spec}
\alias{estimate}
\title{Estimates the parameters of a distribution using autodiff.}
\usage{
\method{estimate}{tsdistribution.spec}(
  object,
  solver = "nlminb",
  control = list(trace = 0, eval.max = 300, iter.max = 500),
  use_hessian = TRUE,
  ...
)
}
\arguments{
\item{object}{an object of class \dQuote{tsdistribution.spec}.}

\item{solver}{only \dQuote{nlminb} currently supported.}

\item{control}{solver control parameters.}

\item{use_hessian}{whether to use the hessian in the calculation.}

\item{...}{additional parameters passed to the estimation function}
}
\value{
An object of class \dQuote{tsdistribution.estimate} with slots for 
the estimated coefficients, gradients, scores etc.
}
\description{
Estimates the parameters of a distribution using autodiff.
}
\details{
The estimation makes use of the TMB package for minimizing
the negative of the log-likelihood using automatic differentiation.
}
