% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frequdom.r
\name{dynspecest}
\alias{dynspecest}
\title{\code{dynspecest}  performs a dynamic  spectrum estimation}
\usage{
dynspecest(y, nseg, nf, e, theta = 0, phi = 15, d, Plot = FALSE)
}
\arguments{
\item{y}{time series or vector}

\item{nseg}{number of segments for which the spectrum is estimated}

\item{nf}{number of equally spaced frequencies}

\item{e}{equal bandwidth}

\item{theta}{azimuthal viewing direction, see R function persp}

\item{phi}{colatitude viewing direction, see R function persp}

\item{d}{a value to vary the strength of the perspective transformation, see R function persp}

\item{Plot}{logical, schould a plot be generated?}
}
\value{
out list with components
\item{f}{frequencies, vector of length nf }
\item{t}{time, vector of length nseg }
\item{spec}{the spectral estimates, (nf,nt)-matrix    }
}
\description{
\code{dynspecest}  performs a dynamic  spectrum estimation
}
\examples{
data(IBM) 
y <- diff(log(IBM))
out <- dynspecest(y,60,50,0.2,theta=0,phi=15,d=1,Plot=FALSE)
}
