% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setarTest.R
\name{setarTest}
\alias{setarTest}
\alias{setartest}
\title{Test of linearity against threshold (SETAR)}
\usage{
setarTest(
  x,
  m,
  thDelay = 0,
  trim = 0.1,
  include = c("const", "trend", "none", "both"),
  nboot = 10,
  test = c("1vs", "2vs3"),
  hpc = c("none", "foreach"),
  boot.scheme = c("resample", "resample_block", "wild1", "wild2", "check")
)
}
\arguments{
\item{x}{time series}

\item{m, thDelay}{lag and 'time delay' for the threshold variable}

\item{trim}{trimming parameter indicating the minimal percentage of
observations in each regime}

\item{include}{Type of deterministic regressors to include: none, a constant, a trend, or constant and trend (\code{both}).}

\item{nboot}{number of bootstrap replications}

\item{test}{whether to test AR against SETAR, or SETAR(1 reg) against SETAR(2 reg)}

\item{hpc}{Possibility to run the bootstrap on parallel core. See details in
\code{\link{TVECM.HStest}}}

\item{boot.scheme}{Type of resampling scheme to use for the residuals. See \code{\link{resample_vec}}.}
}
\value{
A object of class "Hansen99Test" containing:

\item{SSRs}{The residual Sum of squares of model AR, 1 threshold TAR and 2
thresholds TAR}

\item{Ftests}{The Ftest statistic for the test}

\item{PvalBoot}{The bootstrap p-values for the test selected}
\item{CriticalValBoot}{The critical values for the test selected}
\item{Ftestboot}{All the F-test computed} \item{firstBests, secBests}{The
thresholds for the original series, obtained from search for 1 thresh
(\code{firstBests}) and conditional search for 2 thresh (secBests)}
\item{nboot,m}{The number of bootstrap replications (\code{nboot}), the
lags used (\code{m})}
}
\description{
Test of linearity against threshold of Hansen (1999) with bootstrap
distribution
}
\details{
Estimation of the first threshold parameter is made with CLS, a conditional
search with one iteration is made for the second threshold. The Ftest
comparing the residual sum of squares (SSR) of each model is computed.

\deqn{ F_{ij}=T( (S_{i}-S_{j})/S_{j} )}

where \eqn{S_{i}} is the SSR of the model with i regimes (and so i-1
thresholds).

Three test are available. The both first can be seen as linearity test,
whereas the third can be seen as a specification test: once the 1vs2 or/and
1vs3 rejected the linearity and henceforth accepted the presence of a
threshold, is a model with one or two thresholds preferable?

Test \bold{1vs}2: Linear AR versus 1 threshold TAR

Test \bold{1vs}3: Linear AR versus 2 thresholds TAR

Test \bold{2vs3}: 1 threshold TAR versus 2 thresholds TAR

The two first tests are computed together and available with test="1vs". The
third test is available with test="2vs3".

The homoskedastic bootstrap distribution is based on resampling the
residuals from H0 model (ar for test 1vs, and setar(1) for test 2vs3),
estimating the threshold parameter and then computing the Ftest, so it
involves many computations and is pretty slow.
}
\examples{

#Data used by Hansen
sun <- (sqrt(sunspot.year + 1) - 1) * 2

#Test 1vs2 and 1vs3
#setarTest(sun, m=11, thDelay=0:1, nboot=5,trim=0.1, test="1vs")
}
\references{
Hansen (1999) Testing for linearity, Journal of Economic
Surveys, Volume 13, Number 5, December 1999 , pp. 551-576(26) available at:
\url{http://www.ssc.wisc.edu/~bhansen/papers/cv.htm}
}
\seealso{
\code{\link{TVAR.LRtest}} for the multivariate version.
\code{\link{SETAR}} for estimation of the model.
}
\author{
Matthieu Stigler
}
\keyword{ts}
