% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{events_from_ts}
\alias{events_from_ts}
\title{Extract events from a time series.}
\usage{
events_from_ts(
  ts,
  th,
  method = c("greater_than", "lower_than", "top_percentile", "lower_percentile",
    "highest", "lowest"),
  return_marked_times = FALSE
)
}
\arguments{
\item{ts}{Array. Time series}

\item{th}{A threshold (if `method=greater_than` or `=lower_than`), or the
percentile (if `method=top_percentile` or `=lower_percentile`), or the
total number (if `method=highest` or `=lowest`).}

\item{method}{String. One of following options:
* `greater_than`: All values greater or equal to `th`.
* `lower_than`: All values lower or equal to `th`.
* `top_percentile`: Values greater than the `th` percentile.
* `highest`: The top `th` values.
* `lowest`: The lower `th` values.}

\item{return_marked_times}{Return the time indices (marked points) where
the events occur.}
}
\value{
An event (binary, 1: event, 0 otherwise) time series
}
\description{
This function transforms an time series (array) into a binary time series
where 1 means a event and 0 means no event.
}
