% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/triples.R
\name{triples}
\alias{triples}
\title{Create a triples match}
\usage{
triples(cost, z, st, solver = "rrelaxiv")
}
\arguments{
\item{cost}{List of matrices of distances between treated (rows) and control (columns) units within a stratum
with one entry in the list per stratum}

\item{z}{Vector of treatment assignment (0 for control, 1 for treated)}

\item{st}{Vector of stratum assignments}

\item{solver}{Solver to use for the network problem. Either 'rrelaxiv' or 'rlemon'.
'rrelaxiv' can be downloaded from "https://github.com/josherrickson/rrelaxiv/"}
}
\value{
Named list with three elements: `m` contains the triples match. This is in the form of a
 data.frame with number of rows equal to the number of triples and 8 columns specifying the
 match number, the names of the three units within the match, the costs of the two
 treated-control pairs within the match, the number of treated units, and the stratum. `obj`
 contains the total objective from the network optimization and `bound` contains
 a loose lower bound on the objective of the optimal match.
}
\description{
Create a triples match
}
\examples{
# Generate some data
set.seed(1)
n <- 40
x <- rnorm(n, 0, 1)
nt <- floor(n * 0.4)
nc <- n - nt
z <- c(rep(1, nt), rep(0, nc))
# Create some strata
ps <- glm(z ~ x, family = binomial)$fitted.values
ps_st <- cut(ps, c(0, quantile(ps, 1/3 * 1:2), 1), labels = 1:3)
# Create a distance matrix
dist <- dist_mahal(data.frame(x = x), z, ps_st)
# Construct the triples match
triplesm <- triples(cost = dist, z = z, st = ps_st, solver = "rlemon")

}
