% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy.R
\name{cogs}
\alias{cogs}
\title{Cogs Wrapper Function}
\usage{
cogs(.x, .f, ...)
}
\arguments{
\item{.x}{a list or atomic vector (see \code{\link[purrr]{map}} for details)}

\item{.f}{a function, formula, or atomic vector (see \code{\link[purrr]{map}} for details)}

\item{...}{additional arguments passed on to .f (see \code{\link[purrr]{map}} for details)}
}
\description{
Cogs Wrapper Function
}
\details{
See \code{\link[purrr]{map}}
}
\examples{
\donttest{
library(dplyr)
library(tidyr)
library(rbokeh)
ggplot2::mpg \%>\%
  group_by(manufacturer, class) \%>\%
  nest() \%>\%
  mutate(
    additional_cogs = map_cog(data,
      ~ tibble(
        max_city_mpg = cog(max(.x$cty), desc = "Max city mpg"),
        min_city_mpg = cog(min(.x$cty), desc = "Min city mpg"))),
    panel = map_plot(data, ~ figure(xlab = "City mpg", ylab = "Highway mpg") \%>\%
      ly_points(cty, hwy, data = .x))) \%>\%
  trelliscope(name = "city_vs_highway_mpg", nrow = 1, ncol = 2)
}
}
