% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splod.R
\name{splod}
\alias{splod}
\title{Create a Scatterplot Display}
\usage{
splod(data, id.vars = NULL, name = NULL, desc = NULL,
  cogFn = splodCogFn, panelFn = splodPanelFn, verbose = TRUE, ...)
}
\arguments{
\item{data}{a data.frame or an object of class "splodDat"}

\item{id.vars}{variables to ignore when computing all pairs of variables}

\item{name, desc, cogFn, panelFn, verbose, \ldots}{parameters passed to \code{\link{makeDisplay}}}
}
\value{
an object of class 'localDiv' that can be passed to \code{\link{splod}}
}
\description{
Create a scatterplot display (splod)
}
\examples{
\dontrun{
library(lattice)

vdbConn(tempfile(), autoYes = TRUE)

# make "splod" directly from a data frame
splod(batting, name = "batting",
  id.vars = c("playerID", "yearID", "stint", "teamID", "lgID"))

# first transform the data into a "splodDat" object
batSplodDat <- makeSplodData(batting,
  id.vars = c("playerID", "yearID", "stint", "teamID", "lgID"))
# now make "splod"
splod(batSplodDat, name = "batting2", data = batSplodDat)

# custom panel function (color by league)
mySplodFn <- function(d) {
  xyplot(jitter(y) ~ jitter(x), groups = lgID, data = d,
    xlab = getSplitVar(d, "xVar"),
    ylab = getSplitVar(d, "yVar"),
    auto.key = TRUE
  )
}

splod(batSplodDat, name = "batting3",
  data = batSplodDat, panelFn = mySplodFn)

view()
}
}
\references{
Wilkinson, L., Anushka A., and Grossman, R. L. "Graph-Theoretic Scagnostics." INFOVIS. Vol. 5. 2005.
}
\seealso{
\code{\link{makeDisplay}}, \code{\link{makeSplodData}}, \code{\link{splodPanelFn}}
}
