% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isle_post.R
\name{isle_post}
\alias{isle_post}
\title{Importance sampled learning ensemble}
\usage{
isle_post(
  X,
  y,
  newX = NULL,
  newy = NULL,
  cv = FALSE,
  nfolds = 5,
  family = NULL,
  loss = "default",
  offset = NULL,
  ...
)
}
\arguments{
\item{X}{A matrix of training predictions, one column for each tree in the
ensemble.}

\item{y}{Vector of training response values. See \code{\link[glmnet]{glmnet}} 
for acceptable values (e.g., numeric for \code{family = "gaussian"}).}

\item{newX}{Same as argument \code{X}, but should correspond to an 
independent test set. (Required whenever \code{cv = FALSE}.)}

\item{newy}{Same as argument \code{y}, but should correspond to an 
independent test set. (Required whenever \code{cv = FALSE}.)}

\item{cv}{Logical indicating whether or not to use n-fold cross-validation.
Default is \code{FALSE} (Must be \code{TRUE} whenever \code{newX = NULL} and 
\code{newy = NULL}.)}

\item{nfolds}{Integer specifying the number of folds to use for 
cross-validation (i.e., whenever \code{cv = TRUE}). Default is \code{FALSE}.}

\item{family}{The model fitting family (e.g., \code{family = "binomial"} for
binary outcomes); see \code{\link[glmnet]{glmnet}} for details on acceptable 
values.}

\item{loss}{Optional character string specifying the loss to use for 
n-fold cross-validation. Default is \code{"default"}; see
\code{\link[glmnet]{cv.glmnet}} for details. (Only used when 
\code{cv = TRUE}.)}

\item{offset}{Optional value for the offset. Default is \code{NULL}, which
corresponds to no offset.}

\item{...}{Additional (optional) arguments to be passed on to 
\code{\link[glmnet]{glmnet}} (e.g., \code{intercept = FALSE}).}
}
\value{
A list with two components:
\describe{
  \item{\code{results}}{A data frame with one row for each value of lambda in
  the coefficient path and columns giving the corresponding number of 
  trees/non-zero coefficients, error metric(s), and the corresponding value 
  of lambda.}
  \item{lasso.fit}{The fitted \code{\link[glmnet]{glmnet}} or 
  \code{\link[glmnet]{cv.glmnet}} object.}
}
}
\description{
Uses \code{\link[glmnet]{glmnet}} or \code{\link[glmnet]{cv.glmnet}} to fit 
the entire LASSO path for post-processing the individual trees of a 
tree-based ensemble (e.g., a random forest).
}
